package software.amazon.awscdk.interfaces.gamelift;

/**
 * A reference to a Build resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.gamelift.*;
 * BuildReference buildReference = BuildReference.builder()
 *         .buildArn("buildArn")
 *         .buildId("buildId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.395Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_gamelift.BuildReference")
@software.amazon.jsii.Jsii.Proxy(BuildReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BuildReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Build resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBuildArn();

    /**
     * The BuildId of the Build resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBuildId();

    /**
     * @return a {@link Builder} of {@link BuildReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BuildReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BuildReference> {
        java.lang.String buildArn;
        java.lang.String buildId;

        /**
         * Sets the value of {@link BuildReference#getBuildArn}
         * @param buildArn The ARN of the Build resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArn(java.lang.String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        /**
         * Sets the value of {@link BuildReference#getBuildId}
         * @param buildId The BuildId of the Build resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildId(java.lang.String buildId) {
            this.buildId = buildId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BuildReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BuildReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BuildReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BuildReference {
        private final java.lang.String buildArn;
        private final java.lang.String buildId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildArn = software.amazon.jsii.Kernel.get(this, "buildArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildId = software.amazon.jsii.Kernel.get(this, "buildId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildArn = java.util.Objects.requireNonNull(builder.buildArn, "buildArn is required");
            this.buildId = java.util.Objects.requireNonNull(builder.buildId, "buildId is required");
        }

        @Override
        public final java.lang.String getBuildArn() {
            return this.buildArn;
        }

        @Override
        public final java.lang.String getBuildId() {
            return this.buildId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("buildArn", om.valueToTree(this.getBuildArn()));
            data.set("buildId", om.valueToTree(this.getBuildId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_gamelift.BuildReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BuildReference.Jsii$Proxy that = (BuildReference.Jsii$Proxy) o;

            if (!buildArn.equals(that.buildArn)) return false;
            return this.buildId.equals(that.buildId);
        }

        @Override
        public final int hashCode() {
            int result = this.buildArn.hashCode();
            result = 31 * result + (this.buildId.hashCode());
            return result;
        }
    }
}
