package software.amazon.awscdk.interfaces.gamelift;

/**
 * A reference to a GameSessionQueue resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.gamelift.*;
 * GameSessionQueueReference gameSessionQueueReference = GameSessionQueueReference.builder()
 *         .gameSessionQueueArn("gameSessionQueueArn")
 *         .gameSessionQueueName("gameSessionQueueName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.396Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_gamelift.GameSessionQueueReference")
@software.amazon.jsii.Jsii.Proxy(GameSessionQueueReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GameSessionQueueReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the GameSessionQueue resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGameSessionQueueArn();

    /**
     * The Name of the GameSessionQueue resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGameSessionQueueName();

    /**
     * @return a {@link Builder} of {@link GameSessionQueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GameSessionQueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GameSessionQueueReference> {
        java.lang.String gameSessionQueueArn;
        java.lang.String gameSessionQueueName;

        /**
         * Sets the value of {@link GameSessionQueueReference#getGameSessionQueueArn}
         * @param gameSessionQueueArn The ARN of the GameSessionQueue resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionQueueArn(java.lang.String gameSessionQueueArn) {
            this.gameSessionQueueArn = gameSessionQueueArn;
            return this;
        }

        /**
         * Sets the value of {@link GameSessionQueueReference#getGameSessionQueueName}
         * @param gameSessionQueueName The Name of the GameSessionQueue resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionQueueName(java.lang.String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GameSessionQueueReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GameSessionQueueReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GameSessionQueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GameSessionQueueReference {
        private final java.lang.String gameSessionQueueArn;
        private final java.lang.String gameSessionQueueName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gameSessionQueueArn = software.amazon.jsii.Kernel.get(this, "gameSessionQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gameSessionQueueName = software.amazon.jsii.Kernel.get(this, "gameSessionQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gameSessionQueueArn = java.util.Objects.requireNonNull(builder.gameSessionQueueArn, "gameSessionQueueArn is required");
            this.gameSessionQueueName = java.util.Objects.requireNonNull(builder.gameSessionQueueName, "gameSessionQueueName is required");
        }

        @Override
        public final java.lang.String getGameSessionQueueArn() {
            return this.gameSessionQueueArn;
        }

        @Override
        public final java.lang.String getGameSessionQueueName() {
            return this.gameSessionQueueName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("gameSessionQueueArn", om.valueToTree(this.getGameSessionQueueArn()));
            data.set("gameSessionQueueName", om.valueToTree(this.getGameSessionQueueName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_gamelift.GameSessionQueueReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GameSessionQueueReference.Jsii$Proxy that = (GameSessionQueueReference.Jsii$Proxy) o;

            if (!gameSessionQueueArn.equals(that.gameSessionQueueArn)) return false;
            return this.gameSessionQueueName.equals(that.gameSessionQueueName);
        }

        @Override
        public final int hashCode() {
            int result = this.gameSessionQueueArn.hashCode();
            result = 31 * result + (this.gameSessionQueueName.hashCode());
            return result;
        }
    }
}
