package software.amazon.awscdk.interfaces.gamelift;

/**
 * A reference to a MatchmakingRuleSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.gamelift.*;
 * MatchmakingRuleSetReference matchmakingRuleSetReference = MatchmakingRuleSetReference.builder()
 *         .matchmakingRuleSetArn("matchmakingRuleSetArn")
 *         .matchmakingRuleSetName("matchmakingRuleSetName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.401Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_gamelift.MatchmakingRuleSetReference")
@software.amazon.jsii.Jsii.Proxy(MatchmakingRuleSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MatchmakingRuleSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the MatchmakingRuleSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMatchmakingRuleSetArn();

    /**
     * The Name of the MatchmakingRuleSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMatchmakingRuleSetName();

    /**
     * @return a {@link Builder} of {@link MatchmakingRuleSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MatchmakingRuleSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MatchmakingRuleSetReference> {
        java.lang.String matchmakingRuleSetArn;
        java.lang.String matchmakingRuleSetName;

        /**
         * Sets the value of {@link MatchmakingRuleSetReference#getMatchmakingRuleSetArn}
         * @param matchmakingRuleSetArn The ARN of the MatchmakingRuleSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchmakingRuleSetArn(java.lang.String matchmakingRuleSetArn) {
            this.matchmakingRuleSetArn = matchmakingRuleSetArn;
            return this;
        }

        /**
         * Sets the value of {@link MatchmakingRuleSetReference#getMatchmakingRuleSetName}
         * @param matchmakingRuleSetName The Name of the MatchmakingRuleSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchmakingRuleSetName(java.lang.String matchmakingRuleSetName) {
            this.matchmakingRuleSetName = matchmakingRuleSetName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MatchmakingRuleSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MatchmakingRuleSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MatchmakingRuleSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchmakingRuleSetReference {
        private final java.lang.String matchmakingRuleSetArn;
        private final java.lang.String matchmakingRuleSetName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.matchmakingRuleSetArn = software.amazon.jsii.Kernel.get(this, "matchmakingRuleSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.matchmakingRuleSetName = software.amazon.jsii.Kernel.get(this, "matchmakingRuleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.matchmakingRuleSetArn = java.util.Objects.requireNonNull(builder.matchmakingRuleSetArn, "matchmakingRuleSetArn is required");
            this.matchmakingRuleSetName = java.util.Objects.requireNonNull(builder.matchmakingRuleSetName, "matchmakingRuleSetName is required");
        }

        @Override
        public final java.lang.String getMatchmakingRuleSetArn() {
            return this.matchmakingRuleSetArn;
        }

        @Override
        public final java.lang.String getMatchmakingRuleSetName() {
            return this.matchmakingRuleSetName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("matchmakingRuleSetArn", om.valueToTree(this.getMatchmakingRuleSetArn()));
            data.set("matchmakingRuleSetName", om.valueToTree(this.getMatchmakingRuleSetName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_gamelift.MatchmakingRuleSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MatchmakingRuleSetReference.Jsii$Proxy that = (MatchmakingRuleSetReference.Jsii$Proxy) o;

            if (!matchmakingRuleSetArn.equals(that.matchmakingRuleSetArn)) return false;
            return this.matchmakingRuleSetName.equals(that.matchmakingRuleSetName);
        }

        @Override
        public final int hashCode() {
            int result = this.matchmakingRuleSetArn.hashCode();
            result = 31 * result + (this.matchmakingRuleSetName.hashCode());
            return result;
        }
    }
}
