package software.amazon.awscdk.interfaces.globalaccelerator;

/**
 * A reference to a Accelerator resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.globalaccelerator.*;
 * AcceleratorReference acceleratorReference = AcceleratorReference.builder()
 *         .acceleratorArn("acceleratorArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.402Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_globalaccelerator.AcceleratorReference")
@software.amazon.jsii.Jsii.Proxy(AcceleratorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AcceleratorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AcceleratorArn of the Accelerator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAcceleratorArn();

    /**
     * @return a {@link Builder} of {@link AcceleratorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AcceleratorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AcceleratorReference> {
        java.lang.String acceleratorArn;

        /**
         * Sets the value of {@link AcceleratorReference#getAcceleratorArn}
         * @param acceleratorArn The AcceleratorArn of the Accelerator resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceleratorArn(java.lang.String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AcceleratorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AcceleratorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AcceleratorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorReference {
        private final java.lang.String acceleratorArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceleratorArn = software.amazon.jsii.Kernel.get(this, "acceleratorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceleratorArn = java.util.Objects.requireNonNull(builder.acceleratorArn, "acceleratorArn is required");
        }

        @Override
        public final java.lang.String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("acceleratorArn", om.valueToTree(this.getAcceleratorArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_globalaccelerator.AcceleratorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AcceleratorReference.Jsii$Proxy that = (AcceleratorReference.Jsii$Proxy) o;

            return this.acceleratorArn.equals(that.acceleratorArn);
        }

        @Override
        public final int hashCode() {
            int result = this.acceleratorArn.hashCode();
            return result;
        }
    }
}
