package software.amazon.awscdk.interfaces.glue;

/**
 * A reference to a TableOptimizer resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.glue.*;
 * TableOptimizerReference tableOptimizerReference = TableOptimizerReference.builder()
 *         .tableOptimizerId("tableOptimizerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.426Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_glue.TableOptimizerReference")
@software.amazon.jsii.Jsii.Proxy(TableOptimizerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableOptimizerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the TableOptimizer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableOptimizerId();

    /**
     * @return a {@link Builder} of {@link TableOptimizerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableOptimizerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableOptimizerReference> {
        java.lang.String tableOptimizerId;

        /**
         * Sets the value of {@link TableOptimizerReference#getTableOptimizerId}
         * @param tableOptimizerId The Id of the TableOptimizer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableOptimizerId(java.lang.String tableOptimizerId) {
            this.tableOptimizerId = tableOptimizerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableOptimizerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableOptimizerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableOptimizerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableOptimizerReference {
        private final java.lang.String tableOptimizerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tableOptimizerId = software.amazon.jsii.Kernel.get(this, "tableOptimizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tableOptimizerId = java.util.Objects.requireNonNull(builder.tableOptimizerId, "tableOptimizerId is required");
        }

        @Override
        public final java.lang.String getTableOptimizerId() {
            return this.tableOptimizerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("tableOptimizerId", om.valueToTree(this.getTableOptimizerId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_glue.TableOptimizerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableOptimizerReference.Jsii$Proxy that = (TableOptimizerReference.Jsii$Proxy) o;

            return this.tableOptimizerId.equals(that.tableOptimizerId);
        }

        @Override
        public final int hashCode() {
            int result = this.tableOptimizerId.hashCode();
            return result;
        }
    }
}
