package software.amazon.awscdk.interfaces.guardduty;

/**
 * A reference to a PublishingDestination resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.guardduty.*;
 * PublishingDestinationReference publishingDestinationReference = PublishingDestinationReference.builder()
 *         .detectorId("detectorId")
 *         .publishingDestinationId("publishingDestinationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.457Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_guardduty.PublishingDestinationReference")
@software.amazon.jsii.Jsii.Proxy(PublishingDestinationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublishingDestinationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DetectorId of the PublishingDestination resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorId();

    /**
     * The Id of the PublishingDestination resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublishingDestinationId();

    /**
     * @return a {@link Builder} of {@link PublishingDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublishingDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublishingDestinationReference> {
        java.lang.String detectorId;
        java.lang.String publishingDestinationId;

        /**
         * Sets the value of {@link PublishingDestinationReference#getDetectorId}
         * @param detectorId The DetectorId of the PublishingDestination resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(java.lang.String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        /**
         * Sets the value of {@link PublishingDestinationReference#getPublishingDestinationId}
         * @param publishingDestinationId The Id of the PublishingDestination resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishingDestinationId(java.lang.String publishingDestinationId) {
            this.publishingDestinationId = publishingDestinationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublishingDestinationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublishingDestinationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublishingDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublishingDestinationReference {
        private final java.lang.String detectorId;
        private final java.lang.String publishingDestinationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detectorId = software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishingDestinationId = software.amazon.jsii.Kernel.get(this, "publishingDestinationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detectorId = java.util.Objects.requireNonNull(builder.detectorId, "detectorId is required");
            this.publishingDestinationId = java.util.Objects.requireNonNull(builder.publishingDestinationId, "publishingDestinationId is required");
        }

        @Override
        public final java.lang.String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final java.lang.String getPublishingDestinationId() {
            return this.publishingDestinationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detectorId", om.valueToTree(this.getDetectorId()));
            data.set("publishingDestinationId", om.valueToTree(this.getPublishingDestinationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_guardduty.PublishingDestinationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublishingDestinationReference.Jsii$Proxy that = (PublishingDestinationReference.Jsii$Proxy) o;

            if (!detectorId.equals(that.detectorId)) return false;
            return this.publishingDestinationId.equals(that.publishingDestinationId);
        }

        @Override
        public final int hashCode() {
            int result = this.detectorId.hashCode();
            result = 31 * result + (this.publishingDestinationId.hashCode());
            return result;
        }
    }
}
