package software.amazon.awscdk.interfaces.healthimaging;

/**
 * A reference to a Datastore resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.healthimaging.*;
 * DatastoreReference datastoreReference = DatastoreReference.builder()
 *         .datastoreArn("datastoreArn")
 *         .datastoreId("datastoreId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.458Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_healthimaging.DatastoreReference")
@software.amazon.jsii.Jsii.Proxy(DatastoreReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatastoreReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Datastore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatastoreArn();

    /**
     * The DatastoreId of the Datastore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatastoreId();

    /**
     * @return a {@link Builder} of {@link DatastoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatastoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatastoreReference> {
        java.lang.String datastoreArn;
        java.lang.String datastoreId;

        /**
         * Sets the value of {@link DatastoreReference#getDatastoreArn}
         * @param datastoreArn The ARN of the Datastore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreArn(java.lang.String datastoreArn) {
            this.datastoreArn = datastoreArn;
            return this;
        }

        /**
         * Sets the value of {@link DatastoreReference#getDatastoreId}
         * @param datastoreId The DatastoreId of the Datastore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreId(java.lang.String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatastoreReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatastoreReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatastoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatastoreReference {
        private final java.lang.String datastoreArn;
        private final java.lang.String datastoreId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.datastoreArn = software.amazon.jsii.Kernel.get(this, "datastoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datastoreId = software.amazon.jsii.Kernel.get(this, "datastoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.datastoreArn = java.util.Objects.requireNonNull(builder.datastoreArn, "datastoreArn is required");
            this.datastoreId = java.util.Objects.requireNonNull(builder.datastoreId, "datastoreId is required");
        }

        @Override
        public final java.lang.String getDatastoreArn() {
            return this.datastoreArn;
        }

        @Override
        public final java.lang.String getDatastoreId() {
            return this.datastoreId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("datastoreArn", om.valueToTree(this.getDatastoreArn()));
            data.set("datastoreId", om.valueToTree(this.getDatastoreId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_healthimaging.DatastoreReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatastoreReference.Jsii$Proxy that = (DatastoreReference.Jsii$Proxy) o;

            if (!datastoreArn.equals(that.datastoreArn)) return false;
            return this.datastoreId.equals(that.datastoreId);
        }

        @Override
        public final int hashCode() {
            int result = this.datastoreArn.hashCode();
            result = 31 * result + (this.datastoreId.hashCode());
            return result;
        }
    }
}
