package software.amazon.awscdk.interfaces.imagebuilder;

/**
 * A reference to a Workflow resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.imagebuilder.*;
 * WorkflowReference workflowReference = WorkflowReference.builder()
 *         .workflowArn("workflowArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.476Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_imagebuilder.WorkflowReference")
@software.amazon.jsii.Jsii.Proxy(WorkflowReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WorkflowReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the Workflow resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkflowArn();

    /**
     * @return a {@link Builder} of {@link WorkflowReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WorkflowReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WorkflowReference> {
        java.lang.String workflowArn;

        /**
         * Sets the value of {@link WorkflowReference#getWorkflowArn}
         * @param workflowArn The Arn of the Workflow resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowArn(java.lang.String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WorkflowReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WorkflowReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WorkflowReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowReference {
        private final java.lang.String workflowArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.workflowArn = software.amazon.jsii.Kernel.get(this, "workflowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.workflowArn = java.util.Objects.requireNonNull(builder.workflowArn, "workflowArn is required");
        }

        @Override
        public final java.lang.String getWorkflowArn() {
            return this.workflowArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("workflowArn", om.valueToTree(this.getWorkflowArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_imagebuilder.WorkflowReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WorkflowReference.Jsii$Proxy that = (WorkflowReference.Jsii$Proxy) o;

            return this.workflowArn.equals(that.workflowArn);
        }

        @Override
        public final int hashCode() {
            int result = this.workflowArn.hashCode();
            return result;
        }
    }
}
