package software.amazon.awscdk.interfaces.inspectorv2;

/**
 * A reference to a CodeSecurityIntegration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.inspectorv2.*;
 * CodeSecurityIntegrationReference codeSecurityIntegrationReference = CodeSecurityIntegrationReference.builder()
 *         .codeSecurityIntegrationArn("codeSecurityIntegrationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.478Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_inspectorv2.CodeSecurityIntegrationReference")
@software.amazon.jsii.Jsii.Proxy(CodeSecurityIntegrationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeSecurityIntegrationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the CodeSecurityIntegration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCodeSecurityIntegrationArn();

    /**
     * @return a {@link Builder} of {@link CodeSecurityIntegrationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeSecurityIntegrationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeSecurityIntegrationReference> {
        java.lang.String codeSecurityIntegrationArn;

        /**
         * Sets the value of {@link CodeSecurityIntegrationReference#getCodeSecurityIntegrationArn}
         * @param codeSecurityIntegrationArn The Arn of the CodeSecurityIntegration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSecurityIntegrationArn(java.lang.String codeSecurityIntegrationArn) {
            this.codeSecurityIntegrationArn = codeSecurityIntegrationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeSecurityIntegrationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeSecurityIntegrationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeSecurityIntegrationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeSecurityIntegrationReference {
        private final java.lang.String codeSecurityIntegrationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeSecurityIntegrationArn = software.amazon.jsii.Kernel.get(this, "codeSecurityIntegrationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeSecurityIntegrationArn = java.util.Objects.requireNonNull(builder.codeSecurityIntegrationArn, "codeSecurityIntegrationArn is required");
        }

        @Override
        public final java.lang.String getCodeSecurityIntegrationArn() {
            return this.codeSecurityIntegrationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("codeSecurityIntegrationArn", om.valueToTree(this.getCodeSecurityIntegrationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_inspectorv2.CodeSecurityIntegrationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeSecurityIntegrationReference.Jsii$Proxy that = (CodeSecurityIntegrationReference.Jsii$Proxy) o;

            return this.codeSecurityIntegrationArn.equals(that.codeSecurityIntegrationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.codeSecurityIntegrationArn.hashCode();
            return result;
        }
    }
}
