package software.amazon.awscdk.interfaces.iot;

/**
 * A reference to a Authorizer resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iot.*;
 * AuthorizerReference authorizerReference = AuthorizerReference.builder()
 *         .authorizerArn("authorizerArn")
 *         .authorizerName("authorizerName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.492Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iot.AuthorizerReference")
@software.amazon.jsii.Jsii.Proxy(AuthorizerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AuthorizerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Authorizer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerArn();

    /**
     * The AuthorizerName of the Authorizer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerName();

    /**
     * @return a {@link Builder} of {@link AuthorizerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthorizerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AuthorizerReference> {
        java.lang.String authorizerArn;
        java.lang.String authorizerName;

        /**
         * Sets the value of {@link AuthorizerReference#getAuthorizerArn}
         * @param authorizerArn The ARN of the Authorizer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerArn(java.lang.String authorizerArn) {
            this.authorizerArn = authorizerArn;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizerReference#getAuthorizerName}
         * @param authorizerName The AuthorizerName of the Authorizer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthorizerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AuthorizerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AuthorizerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizerReference {
        private final java.lang.String authorizerArn;
        private final java.lang.String authorizerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizerArn = software.amazon.jsii.Kernel.get(this, "authorizerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizerArn = java.util.Objects.requireNonNull(builder.authorizerArn, "authorizerArn is required");
            this.authorizerName = java.util.Objects.requireNonNull(builder.authorizerName, "authorizerName is required");
        }

        @Override
        public final java.lang.String getAuthorizerArn() {
            return this.authorizerArn;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizerArn", om.valueToTree(this.getAuthorizerArn()));
            data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iot.AuthorizerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthorizerReference.Jsii$Proxy that = (AuthorizerReference.Jsii$Proxy) o;

            if (!authorizerArn.equals(that.authorizerArn)) return false;
            return this.authorizerName.equals(that.authorizerName);
        }

        @Override
        public final int hashCode() {
            int result = this.authorizerArn.hashCode();
            result = 31 * result + (this.authorizerName.hashCode());
            return result;
        }
    }
}
