package software.amazon.awscdk.interfaces.iot;

/**
 * A reference to a ThingGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iot.*;
 * ThingGroupReference thingGroupReference = ThingGroupReference.builder()
 *         .thingGroupArn("thingGroupArn")
 *         .thingGroupName("thingGroupName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iot.ThingGroupReference")
@software.amazon.jsii.Jsii.Proxy(ThingGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThingGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ThingGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThingGroupArn();

    /**
     * The ThingGroupName of the ThingGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThingGroupName();

    /**
     * @return a {@link Builder} of {@link ThingGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThingGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThingGroupReference> {
        java.lang.String thingGroupArn;
        java.lang.String thingGroupName;

        /**
         * Sets the value of {@link ThingGroupReference#getThingGroupArn}
         * @param thingGroupArn The ARN of the ThingGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingGroupArn(java.lang.String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link ThingGroupReference#getThingGroupName}
         * @param thingGroupName The ThingGroupName of the ThingGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingGroupName(java.lang.String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThingGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThingGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThingGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThingGroupReference {
        private final java.lang.String thingGroupArn;
        private final java.lang.String thingGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.thingGroupArn = software.amazon.jsii.Kernel.get(this, "thingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thingGroupName = software.amazon.jsii.Kernel.get(this, "thingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.thingGroupArn = java.util.Objects.requireNonNull(builder.thingGroupArn, "thingGroupArn is required");
            this.thingGroupName = java.util.Objects.requireNonNull(builder.thingGroupName, "thingGroupName is required");
        }

        @Override
        public final java.lang.String getThingGroupArn() {
            return this.thingGroupArn;
        }

        @Override
        public final java.lang.String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("thingGroupArn", om.valueToTree(this.getThingGroupArn()));
            data.set("thingGroupName", om.valueToTree(this.getThingGroupName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iot.ThingGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThingGroupReference.Jsii$Proxy that = (ThingGroupReference.Jsii$Proxy) o;

            if (!thingGroupArn.equals(that.thingGroupArn)) return false;
            return this.thingGroupName.equals(that.thingGroupName);
        }

        @Override
        public final int hashCode() {
            int result = this.thingGroupArn.hashCode();
            result = 31 * result + (this.thingGroupName.hashCode());
            return result;
        }
    }
}
