package software.amazon.awscdk.interfaces.iotsitewise;

/**
 * A reference to a ComputationModel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotsitewise.*;
 * ComputationModelReference computationModelReference = ComputationModelReference.builder()
 *         .computationModelArn("computationModelArn")
 *         .computationModelId("computationModelId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.530Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotsitewise.ComputationModelReference")
@software.amazon.jsii.Jsii.Proxy(ComputationModelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputationModelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ComputationModel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComputationModelArn();

    /**
     * The ComputationModelId of the ComputationModel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComputationModelId();

    /**
     * @return a {@link Builder} of {@link ComputationModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputationModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputationModelReference> {
        java.lang.String computationModelArn;
        java.lang.String computationModelId;

        /**
         * Sets the value of {@link ComputationModelReference#getComputationModelArn}
         * @param computationModelArn The ARN of the ComputationModel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelArn(java.lang.String computationModelArn) {
            this.computationModelArn = computationModelArn;
            return this;
        }

        /**
         * Sets the value of {@link ComputationModelReference#getComputationModelId}
         * @param computationModelId The ComputationModelId of the ComputationModel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelId(java.lang.String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputationModelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputationModelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputationModelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputationModelReference {
        private final java.lang.String computationModelArn;
        private final java.lang.String computationModelId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computationModelArn = software.amazon.jsii.Kernel.get(this, "computationModelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computationModelId = software.amazon.jsii.Kernel.get(this, "computationModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computationModelArn = java.util.Objects.requireNonNull(builder.computationModelArn, "computationModelArn is required");
            this.computationModelId = java.util.Objects.requireNonNull(builder.computationModelId, "computationModelId is required");
        }

        @Override
        public final java.lang.String getComputationModelArn() {
            return this.computationModelArn;
        }

        @Override
        public final java.lang.String getComputationModelId() {
            return this.computationModelId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computationModelArn", om.valueToTree(this.getComputationModelArn()));
            data.set("computationModelId", om.valueToTree(this.getComputationModelId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotsitewise.ComputationModelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputationModelReference.Jsii$Proxy that = (ComputationModelReference.Jsii$Proxy) o;

            if (!computationModelArn.equals(that.computationModelArn)) return false;
            return this.computationModelId.equals(that.computationModelId);
        }

        @Override
        public final int hashCode() {
            int result = this.computationModelArn.hashCode();
            result = 31 * result + (this.computationModelId.hashCode());
            return result;
        }
    }
}
