package software.amazon.awscdk.interfaces.iottwinmaker;

/**
 * A reference to a SyncJob resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iottwinmaker.*;
 * SyncJobReference syncJobReference = SyncJobReference.builder()
 *         .syncJobArn("syncJobArn")
 *         .syncSource("syncSource")
 *         .workspaceId("workspaceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.538Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iottwinmaker.SyncJobReference")
@software.amazon.jsii.Jsii.Proxy(SyncJobReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SyncJobReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SyncJob resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSyncJobArn();

    /**
     * The SyncSource of the SyncJob resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSyncSource();

    /**
     * The WorkspaceId of the SyncJob resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceId();

    /**
     * @return a {@link Builder} of {@link SyncJobReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SyncJobReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SyncJobReference> {
        java.lang.String syncJobArn;
        java.lang.String syncSource;
        java.lang.String workspaceId;

        /**
         * Sets the value of {@link SyncJobReference#getSyncJobArn}
         * @param syncJobArn The ARN of the SyncJob resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncJobArn(java.lang.String syncJobArn) {
            this.syncJobArn = syncJobArn;
            return this;
        }

        /**
         * Sets the value of {@link SyncJobReference#getSyncSource}
         * @param syncSource The SyncSource of the SyncJob resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncSource(java.lang.String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        /**
         * Sets the value of {@link SyncJobReference#getWorkspaceId}
         * @param workspaceId The WorkspaceId of the SyncJob resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceId(java.lang.String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SyncJobReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SyncJobReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SyncJobReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SyncJobReference {
        private final java.lang.String syncJobArn;
        private final java.lang.String syncSource;
        private final java.lang.String workspaceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.syncJobArn = software.amazon.jsii.Kernel.get(this, "syncJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.syncSource = software.amazon.jsii.Kernel.get(this, "syncSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaceId = software.amazon.jsii.Kernel.get(this, "workspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.syncJobArn = java.util.Objects.requireNonNull(builder.syncJobArn, "syncJobArn is required");
            this.syncSource = java.util.Objects.requireNonNull(builder.syncSource, "syncSource is required");
            this.workspaceId = java.util.Objects.requireNonNull(builder.workspaceId, "workspaceId is required");
        }

        @Override
        public final java.lang.String getSyncJobArn() {
            return this.syncJobArn;
        }

        @Override
        public final java.lang.String getSyncSource() {
            return this.syncSource;
        }

        @Override
        public final java.lang.String getWorkspaceId() {
            return this.workspaceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("syncJobArn", om.valueToTree(this.getSyncJobArn()));
            data.set("syncSource", om.valueToTree(this.getSyncSource()));
            data.set("workspaceId", om.valueToTree(this.getWorkspaceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iottwinmaker.SyncJobReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SyncJobReference.Jsii$Proxy that = (SyncJobReference.Jsii$Proxy) o;

            if (!syncJobArn.equals(that.syncJobArn)) return false;
            if (!syncSource.equals(that.syncSource)) return false;
            return this.workspaceId.equals(that.workspaceId);
        }

        @Override
        public final int hashCode() {
            int result = this.syncJobArn.hashCode();
            result = 31 * result + (this.syncSource.hashCode());
            result = 31 * result + (this.workspaceId.hashCode());
            return result;
        }
    }
}
