package software.amazon.awscdk.interfaces.iotwireless;

/**
 * A reference to a MulticastGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotwireless.*;
 * MulticastGroupReference multicastGroupReference = MulticastGroupReference.builder()
 *         .multicastGroupArn("multicastGroupArn")
 *         .multicastGroupId("multicastGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotwireless.MulticastGroupReference")
@software.amazon.jsii.Jsii.Proxy(MulticastGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MulticastGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the MulticastGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMulticastGroupArn();

    /**
     * The Id of the MulticastGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMulticastGroupId();

    /**
     * @return a {@link Builder} of {@link MulticastGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MulticastGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MulticastGroupReference> {
        java.lang.String multicastGroupArn;
        java.lang.String multicastGroupId;

        /**
         * Sets the value of {@link MulticastGroupReference#getMulticastGroupArn}
         * @param multicastGroupArn The ARN of the MulticastGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multicastGroupArn(java.lang.String multicastGroupArn) {
            this.multicastGroupArn = multicastGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link MulticastGroupReference#getMulticastGroupId}
         * @param multicastGroupId The Id of the MulticastGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multicastGroupId(java.lang.String multicastGroupId) {
            this.multicastGroupId = multicastGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MulticastGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MulticastGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MulticastGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MulticastGroupReference {
        private final java.lang.String multicastGroupArn;
        private final java.lang.String multicastGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.multicastGroupArn = software.amazon.jsii.Kernel.get(this, "multicastGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multicastGroupId = software.amazon.jsii.Kernel.get(this, "multicastGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.multicastGroupArn = java.util.Objects.requireNonNull(builder.multicastGroupArn, "multicastGroupArn is required");
            this.multicastGroupId = java.util.Objects.requireNonNull(builder.multicastGroupId, "multicastGroupId is required");
        }

        @Override
        public final java.lang.String getMulticastGroupArn() {
            return this.multicastGroupArn;
        }

        @Override
        public final java.lang.String getMulticastGroupId() {
            return this.multicastGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("multicastGroupArn", om.valueToTree(this.getMulticastGroupArn()));
            data.set("multicastGroupId", om.valueToTree(this.getMulticastGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotwireless.MulticastGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MulticastGroupReference.Jsii$Proxy that = (MulticastGroupReference.Jsii$Proxy) o;

            if (!multicastGroupArn.equals(that.multicastGroupArn)) return false;
            return this.multicastGroupId.equals(that.multicastGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.multicastGroupArn.hashCode();
            result = 31 * result + (this.multicastGroupId.hashCode());
            return result;
        }
    }
}
