package software.amazon.awscdk.interfaces.ivs;

/**
 * A reference to a PublicKey resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ivs.*;
 * PublicKeyReference publicKeyReference = PublicKeyReference.builder()
 *         .publicKeyArn("publicKeyArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.551Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ivs.PublicKeyReference")
@software.amazon.jsii.Jsii.Proxy(PublicKeyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublicKeyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the PublicKey resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublicKeyArn();

    /**
     * @return a {@link Builder} of {@link PublicKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublicKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublicKeyReference> {
        java.lang.String publicKeyArn;

        /**
         * Sets the value of {@link PublicKeyReference#getPublicKeyArn}
         * @param publicKeyArn The Arn of the PublicKey resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKeyArn(java.lang.String publicKeyArn) {
            this.publicKeyArn = publicKeyArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublicKeyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublicKeyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublicKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicKeyReference {
        private final java.lang.String publicKeyArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.publicKeyArn = software.amazon.jsii.Kernel.get(this, "publicKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.publicKeyArn = java.util.Objects.requireNonNull(builder.publicKeyArn, "publicKeyArn is required");
        }

        @Override
        public final java.lang.String getPublicKeyArn() {
            return this.publicKeyArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("publicKeyArn", om.valueToTree(this.getPublicKeyArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ivs.PublicKeyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublicKeyReference.Jsii$Proxy that = (PublicKeyReference.Jsii$Proxy) o;

            return this.publicKeyArn.equals(that.publicKeyArn);
        }

        @Override
        public final int hashCode() {
            int result = this.publicKeyArn.hashCode();
            return result;
        }
    }
}
