package software.amazon.awscdk.interfaces.kendra;

/**
 * A reference to a Faq resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.kendra.*;
 * FaqReference faqReference = FaqReference.builder()
 *         .faqArn("faqArn")
 *         .faqId("faqId")
 *         .indexId("indexId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.565Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_kendra.FaqReference")
@software.amazon.jsii.Jsii.Proxy(FaqReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FaqReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Faq resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFaqArn();

    /**
     * The Id of the Faq resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFaqId();

    /**
     * The IndexId of the Faq resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexId();

    /**
     * @return a {@link Builder} of {@link FaqReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FaqReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FaqReference> {
        java.lang.String faqArn;
        java.lang.String faqId;
        java.lang.String indexId;

        /**
         * Sets the value of {@link FaqReference#getFaqArn}
         * @param faqArn The ARN of the Faq resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder faqArn(java.lang.String faqArn) {
            this.faqArn = faqArn;
            return this;
        }

        /**
         * Sets the value of {@link FaqReference#getFaqId}
         * @param faqId The Id of the Faq resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder faqId(java.lang.String faqId) {
            this.faqId = faqId;
            return this;
        }

        /**
         * Sets the value of {@link FaqReference#getIndexId}
         * @param indexId The IndexId of the Faq resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexId(java.lang.String indexId) {
            this.indexId = indexId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FaqReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FaqReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FaqReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FaqReference {
        private final java.lang.String faqArn;
        private final java.lang.String faqId;
        private final java.lang.String indexId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.faqArn = software.amazon.jsii.Kernel.get(this, "faqArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.faqId = software.amazon.jsii.Kernel.get(this, "faqId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.indexId = software.amazon.jsii.Kernel.get(this, "indexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.faqArn = java.util.Objects.requireNonNull(builder.faqArn, "faqArn is required");
            this.faqId = java.util.Objects.requireNonNull(builder.faqId, "faqId is required");
            this.indexId = java.util.Objects.requireNonNull(builder.indexId, "indexId is required");
        }

        @Override
        public final java.lang.String getFaqArn() {
            return this.faqArn;
        }

        @Override
        public final java.lang.String getFaqId() {
            return this.faqId;
        }

        @Override
        public final java.lang.String getIndexId() {
            return this.indexId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("faqArn", om.valueToTree(this.getFaqArn()));
            data.set("faqId", om.valueToTree(this.getFaqId()));
            data.set("indexId", om.valueToTree(this.getIndexId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_kendra.FaqReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FaqReference.Jsii$Proxy that = (FaqReference.Jsii$Proxy) o;

            if (!faqArn.equals(that.faqArn)) return false;
            if (!faqId.equals(that.faqId)) return false;
            return this.indexId.equals(that.indexId);
        }

        @Override
        public final int hashCode() {
            int result = this.faqArn.hashCode();
            result = 31 * result + (this.faqId.hashCode());
            result = 31 * result + (this.indexId.hashCode());
            return result;
        }
    }
}
