package software.amazon.awscdk.interfaces.kms;

/**
 * A reference to a ReplicaKey resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.kms.*;
 * ReplicaKeyReference replicaKeyReference = ReplicaKeyReference.builder()
 *         .keyId("keyId")
 *         .replicaKeyArn("replicaKeyArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.578Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_kms.ReplicaKeyReference")
@software.amazon.jsii.Jsii.Proxy(ReplicaKeyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReplicaKeyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The KeyId of the ReplicaKey resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyId();

    /**
     * The ARN of the ReplicaKey resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicaKeyArn();

    /**
     * @return a {@link Builder} of {@link ReplicaKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReplicaKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReplicaKeyReference> {
        java.lang.String keyId;
        java.lang.String replicaKeyArn;

        /**
         * Sets the value of {@link ReplicaKeyReference#getKeyId}
         * @param keyId The KeyId of the ReplicaKey resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyId(java.lang.String keyId) {
            this.keyId = keyId;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaKeyReference#getReplicaKeyArn}
         * @param replicaKeyArn The ARN of the ReplicaKey resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaKeyArn(java.lang.String replicaKeyArn) {
            this.replicaKeyArn = replicaKeyArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReplicaKeyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReplicaKeyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReplicaKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaKeyReference {
        private final java.lang.String keyId;
        private final java.lang.String replicaKeyArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyId = software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicaKeyArn = software.amazon.jsii.Kernel.get(this, "replicaKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyId = java.util.Objects.requireNonNull(builder.keyId, "keyId is required");
            this.replicaKeyArn = java.util.Objects.requireNonNull(builder.replicaKeyArn, "replicaKeyArn is required");
        }

        @Override
        public final java.lang.String getKeyId() {
            return this.keyId;
        }

        @Override
        public final java.lang.String getReplicaKeyArn() {
            return this.replicaKeyArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyId", om.valueToTree(this.getKeyId()));
            data.set("replicaKeyArn", om.valueToTree(this.getReplicaKeyArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_kms.ReplicaKeyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReplicaKeyReference.Jsii$Proxy that = (ReplicaKeyReference.Jsii$Proxy) o;

            if (!keyId.equals(that.keyId)) return false;
            return this.replicaKeyArn.equals(that.replicaKeyArn);
        }

        @Override
        public final int hashCode() {
            int result = this.keyId.hashCode();
            result = 31 * result + (this.replicaKeyArn.hashCode());
            return result;
        }
    }
}
