package software.amazon.awscdk.interfaces.lakeformation;

/**
 * A reference to a Permissions resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lakeformation.*;
 * PermissionsReference permissionsReference = PermissionsReference.builder()
 *         .permissionsId("permissionsId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.581Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lakeformation.PermissionsReference")
@software.amazon.jsii.Jsii.Proxy(PermissionsReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PermissionsReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the Permissions resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPermissionsId();

    /**
     * @return a {@link Builder} of {@link PermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PermissionsReference> {
        java.lang.String permissionsId;

        /**
         * Sets the value of {@link PermissionsReference#getPermissionsId}
         * @param permissionsId The Id of the Permissions resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsId(java.lang.String permissionsId) {
            this.permissionsId = permissionsId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PermissionsReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PermissionsReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PermissionsReference {
        private final java.lang.String permissionsId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.permissionsId = software.amazon.jsii.Kernel.get(this, "permissionsId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.permissionsId = java.util.Objects.requireNonNull(builder.permissionsId, "permissionsId is required");
        }

        @Override
        public final java.lang.String getPermissionsId() {
            return this.permissionsId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("permissionsId", om.valueToTree(this.getPermissionsId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lakeformation.PermissionsReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PermissionsReference.Jsii$Proxy that = (PermissionsReference.Jsii$Proxy) o;

            return this.permissionsId.equals(that.permissionsId);
        }

        @Override
        public final int hashCode() {
            int result = this.permissionsId.hashCode();
            return result;
        }
    }
}
