package software.amazon.awscdk.interfaces.lambda;

/**
 * A reference to a EventSourceMapping resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lambda.*;
 * EventSourceMappingReference eventSourceMappingReference = EventSourceMappingReference.builder()
 *         .eventSourceMappingArn("eventSourceMappingArn")
 *         .eventSourceMappingId("eventSourceMappingId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.583Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lambda.EventSourceMappingReference")
@software.amazon.jsii.Jsii.Proxy(EventSourceMappingReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventSourceMappingReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the EventSourceMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingArn();

    /**
     * The Id of the EventSourceMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingId();

    /**
     * @return a {@link Builder} of {@link EventSourceMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventSourceMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventSourceMappingReference> {
        java.lang.String eventSourceMappingArn;
        java.lang.String eventSourceMappingId;

        /**
         * Sets the value of {@link EventSourceMappingReference#getEventSourceMappingArn}
         * @param eventSourceMappingArn The ARN of the EventSourceMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceMappingArn(java.lang.String eventSourceMappingArn) {
            this.eventSourceMappingArn = eventSourceMappingArn;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingReference#getEventSourceMappingId}
         * @param eventSourceMappingId The Id of the EventSourceMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceMappingId(java.lang.String eventSourceMappingId) {
            this.eventSourceMappingId = eventSourceMappingId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventSourceMappingReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventSourceMappingReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventSourceMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceMappingReference {
        private final java.lang.String eventSourceMappingArn;
        private final java.lang.String eventSourceMappingId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventSourceMappingArn = software.amazon.jsii.Kernel.get(this, "eventSourceMappingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventSourceMappingId = software.amazon.jsii.Kernel.get(this, "eventSourceMappingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventSourceMappingArn = java.util.Objects.requireNonNull(builder.eventSourceMappingArn, "eventSourceMappingArn is required");
            this.eventSourceMappingId = java.util.Objects.requireNonNull(builder.eventSourceMappingId, "eventSourceMappingId is required");
        }

        @Override
        public final java.lang.String getEventSourceMappingArn() {
            return this.eventSourceMappingArn;
        }

        @Override
        public final java.lang.String getEventSourceMappingId() {
            return this.eventSourceMappingId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventSourceMappingArn", om.valueToTree(this.getEventSourceMappingArn()));
            data.set("eventSourceMappingId", om.valueToTree(this.getEventSourceMappingId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lambda.EventSourceMappingReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventSourceMappingReference.Jsii$Proxy that = (EventSourceMappingReference.Jsii$Proxy) o;

            if (!eventSourceMappingArn.equals(that.eventSourceMappingArn)) return false;
            return this.eventSourceMappingId.equals(that.eventSourceMappingId);
        }

        @Override
        public final int hashCode() {
            int result = this.eventSourceMappingArn.hashCode();
            result = 31 * result + (this.eventSourceMappingId.hashCode());
            return result;
        }
    }
}
