package software.amazon.awscdk.interfaces.lambda;

/**
 * A reference to a LayerVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lambda.*;
 * LayerVersionReference layerVersionReference = LayerVersionReference.builder()
 *         .layerVersionArn("layerVersionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.587Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lambda.LayerVersionReference")
@software.amazon.jsii.Jsii.Proxy(LayerVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LayerVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The LayerVersionArn of the LayerVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLayerVersionArn();

    /**
     * @return a {@link Builder} of {@link LayerVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LayerVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LayerVersionReference> {
        java.lang.String layerVersionArn;

        /**
         * Sets the value of {@link LayerVersionReference#getLayerVersionArn}
         * @param layerVersionArn The LayerVersionArn of the LayerVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerVersionArn(java.lang.String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LayerVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LayerVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LayerVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LayerVersionReference {
        private final java.lang.String layerVersionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.layerVersionArn = software.amazon.jsii.Kernel.get(this, "layerVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.layerVersionArn = java.util.Objects.requireNonNull(builder.layerVersionArn, "layerVersionArn is required");
        }

        @Override
        public final java.lang.String getLayerVersionArn() {
            return this.layerVersionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("layerVersionArn", om.valueToTree(this.getLayerVersionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lambda.LayerVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LayerVersionReference.Jsii$Proxy that = (LayerVersionReference.Jsii$Proxy) o;

            return this.layerVersionArn.equals(that.layerVersionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.layerVersionArn.hashCode();
            return result;
        }
    }
}
