package software.amazon.awscdk.interfaces.lightsail;

/**
 * A reference to a Alarm resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lightsail.*;
 * AlarmReference alarmReference = AlarmReference.builder()
 *         .alarmArn("alarmArn")
 *         .alarmName("alarmName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.602Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lightsail.AlarmReference")
@software.amazon.jsii.Jsii.Proxy(AlarmReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlarmReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Alarm resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlarmArn();

    /**
     * The AlarmName of the Alarm resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

    /**
     * @return a {@link Builder} of {@link AlarmReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlarmReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlarmReference> {
        java.lang.String alarmArn;
        java.lang.String alarmName;

        /**
         * Sets the value of {@link AlarmReference#getAlarmArn}
         * @param alarmArn The ARN of the Alarm resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmArn(java.lang.String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        /**
         * Sets the value of {@link AlarmReference#getAlarmName}
         * @param alarmName The AlarmName of the Alarm resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlarmReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlarmReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlarmReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmReference {
        private final java.lang.String alarmArn;
        private final java.lang.String alarmName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmArn = software.amazon.jsii.Kernel.get(this, "alarmArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmArn = java.util.Objects.requireNonNull(builder.alarmArn, "alarmArn is required");
            this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
        }

        @Override
        public final java.lang.String getAlarmArn() {
            return this.alarmArn;
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmArn", om.valueToTree(this.getAlarmArn()));
            data.set("alarmName", om.valueToTree(this.getAlarmName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lightsail.AlarmReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlarmReference.Jsii$Proxy that = (AlarmReference.Jsii$Proxy) o;

            if (!alarmArn.equals(that.alarmArn)) return false;
            return this.alarmName.equals(that.alarmName);
        }

        @Override
        public final int hashCode() {
            int result = this.alarmArn.hashCode();
            result = 31 * result + (this.alarmName.hashCode());
            return result;
        }
    }
}
