package software.amazon.awscdk.interfaces.lightsail;

/**
 * A reference to a InstanceSnapshot resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lightsail.*;
 * InstanceSnapshotReference instanceSnapshotReference = InstanceSnapshotReference.builder()
 *         .instanceSnapshotArn("instanceSnapshotArn")
 *         .instanceSnapshotName("instanceSnapshotName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.610Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lightsail.InstanceSnapshotReference")
@software.amazon.jsii.Jsii.Proxy(InstanceSnapshotReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceSnapshotReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the InstanceSnapshot resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceSnapshotArn();

    /**
     * The InstanceSnapshotName of the InstanceSnapshot resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceSnapshotName();

    /**
     * @return a {@link Builder} of {@link InstanceSnapshotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceSnapshotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceSnapshotReference> {
        java.lang.String instanceSnapshotArn;
        java.lang.String instanceSnapshotName;

        /**
         * Sets the value of {@link InstanceSnapshotReference#getInstanceSnapshotArn}
         * @param instanceSnapshotArn The ARN of the InstanceSnapshot resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceSnapshotArn(java.lang.String instanceSnapshotArn) {
            this.instanceSnapshotArn = instanceSnapshotArn;
            return this;
        }

        /**
         * Sets the value of {@link InstanceSnapshotReference#getInstanceSnapshotName}
         * @param instanceSnapshotName The InstanceSnapshotName of the InstanceSnapshot resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceSnapshotName(java.lang.String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceSnapshotReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceSnapshotReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceSnapshotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceSnapshotReference {
        private final java.lang.String instanceSnapshotArn;
        private final java.lang.String instanceSnapshotName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceSnapshotArn = software.amazon.jsii.Kernel.get(this, "instanceSnapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceSnapshotName = software.amazon.jsii.Kernel.get(this, "instanceSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceSnapshotArn = java.util.Objects.requireNonNull(builder.instanceSnapshotArn, "instanceSnapshotArn is required");
            this.instanceSnapshotName = java.util.Objects.requireNonNull(builder.instanceSnapshotName, "instanceSnapshotName is required");
        }

        @Override
        public final java.lang.String getInstanceSnapshotArn() {
            return this.instanceSnapshotArn;
        }

        @Override
        public final java.lang.String getInstanceSnapshotName() {
            return this.instanceSnapshotName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceSnapshotArn", om.valueToTree(this.getInstanceSnapshotArn()));
            data.set("instanceSnapshotName", om.valueToTree(this.getInstanceSnapshotName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lightsail.InstanceSnapshotReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceSnapshotReference.Jsii$Proxy that = (InstanceSnapshotReference.Jsii$Proxy) o;

            if (!instanceSnapshotArn.equals(that.instanceSnapshotArn)) return false;
            return this.instanceSnapshotName.equals(that.instanceSnapshotName);
        }

        @Override
        public final int hashCode() {
            int result = this.instanceSnapshotArn.hashCode();
            result = 31 * result + (this.instanceSnapshotName.hashCode());
            return result;
        }
    }
}
