package software.amazon.awscdk.interfaces.lightsail;

/**
 * A reference to a LoadBalancerTlsCertificate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lightsail.*;
 * LoadBalancerTlsCertificateReference loadBalancerTlsCertificateReference = LoadBalancerTlsCertificateReference.builder()
 *         .certificateName("certificateName")
 *         .loadBalancerName("loadBalancerName")
 *         .loadBalancerTlsCertificateArn("loadBalancerTlsCertificateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.610Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lightsail.LoadBalancerTlsCertificateReference")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerTlsCertificateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerTlsCertificateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CertificateName of the LoadBalancerTlsCertificate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateName();

    /**
     * The LoadBalancerName of the LoadBalancerTlsCertificate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerName();

    /**
     * The ARN of the LoadBalancerTlsCertificate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerTlsCertificateArn();

    /**
     * @return a {@link Builder} of {@link LoadBalancerTlsCertificateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerTlsCertificateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerTlsCertificateReference> {
        java.lang.String certificateName;
        java.lang.String loadBalancerName;
        java.lang.String loadBalancerTlsCertificateArn;

        /**
         * Sets the value of {@link LoadBalancerTlsCertificateReference#getCertificateName}
         * @param certificateName The CertificateName of the LoadBalancerTlsCertificate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(java.lang.String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerTlsCertificateReference#getLoadBalancerName}
         * @param loadBalancerName The LoadBalancerName of the LoadBalancerTlsCertificate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerTlsCertificateReference#getLoadBalancerTlsCertificateArn}
         * @param loadBalancerTlsCertificateArn The ARN of the LoadBalancerTlsCertificate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerTlsCertificateArn(java.lang.String loadBalancerTlsCertificateArn) {
            this.loadBalancerTlsCertificateArn = loadBalancerTlsCertificateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerTlsCertificateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerTlsCertificateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerTlsCertificateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerTlsCertificateReference {
        private final java.lang.String certificateName;
        private final java.lang.String loadBalancerName;
        private final java.lang.String loadBalancerTlsCertificateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerTlsCertificateArn = software.amazon.jsii.Kernel.get(this, "loadBalancerTlsCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateName = java.util.Objects.requireNonNull(builder.certificateName, "certificateName is required");
            this.loadBalancerName = java.util.Objects.requireNonNull(builder.loadBalancerName, "loadBalancerName is required");
            this.loadBalancerTlsCertificateArn = java.util.Objects.requireNonNull(builder.loadBalancerTlsCertificateArn, "loadBalancerTlsCertificateArn is required");
        }

        @Override
        public final java.lang.String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final java.lang.String getLoadBalancerTlsCertificateArn() {
            return this.loadBalancerTlsCertificateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificateName", om.valueToTree(this.getCertificateName()));
            data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            data.set("loadBalancerTlsCertificateArn", om.valueToTree(this.getLoadBalancerTlsCertificateArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lightsail.LoadBalancerTlsCertificateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerTlsCertificateReference.Jsii$Proxy that = (LoadBalancerTlsCertificateReference.Jsii$Proxy) o;

            if (!certificateName.equals(that.certificateName)) return false;
            if (!loadBalancerName.equals(that.loadBalancerName)) return false;
            return this.loadBalancerTlsCertificateArn.equals(that.loadBalancerTlsCertificateArn);
        }

        @Override
        public final int hashCode() {
            int result = this.certificateName.hashCode();
            result = 31 * result + (this.loadBalancerName.hashCode());
            result = 31 * result + (this.loadBalancerTlsCertificateArn.hashCode());
            return result;
        }
    }
}
