package software.amazon.awscdk.interfaces.lightsail;

/**
 * A reference to a StaticIp resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lightsail.*;
 * StaticIpReference staticIpReference = StaticIpReference.builder()
 *         .staticIpArn("staticIpArn")
 *         .staticIpName("staticIpName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.611Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lightsail.StaticIpReference")
@software.amazon.jsii.Jsii.Proxy(StaticIpReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StaticIpReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the StaticIp resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStaticIpArn();

    /**
     * The StaticIpName of the StaticIp resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStaticIpName();

    /**
     * @return a {@link Builder} of {@link StaticIpReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StaticIpReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StaticIpReference> {
        java.lang.String staticIpArn;
        java.lang.String staticIpName;

        /**
         * Sets the value of {@link StaticIpReference#getStaticIpArn}
         * @param staticIpArn The ARN of the StaticIp resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticIpArn(java.lang.String staticIpArn) {
            this.staticIpArn = staticIpArn;
            return this;
        }

        /**
         * Sets the value of {@link StaticIpReference#getStaticIpName}
         * @param staticIpName The StaticIpName of the StaticIp resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticIpName(java.lang.String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StaticIpReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StaticIpReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StaticIpReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StaticIpReference {
        private final java.lang.String staticIpArn;
        private final java.lang.String staticIpName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.staticIpArn = software.amazon.jsii.Kernel.get(this, "staticIpArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.staticIpName = software.amazon.jsii.Kernel.get(this, "staticIpName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.staticIpArn = java.util.Objects.requireNonNull(builder.staticIpArn, "staticIpArn is required");
            this.staticIpName = java.util.Objects.requireNonNull(builder.staticIpName, "staticIpName is required");
        }

        @Override
        public final java.lang.String getStaticIpArn() {
            return this.staticIpArn;
        }

        @Override
        public final java.lang.String getStaticIpName() {
            return this.staticIpName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("staticIpArn", om.valueToTree(this.getStaticIpArn()));
            data.set("staticIpName", om.valueToTree(this.getStaticIpName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lightsail.StaticIpReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StaticIpReference.Jsii$Proxy that = (StaticIpReference.Jsii$Proxy) o;

            if (!staticIpArn.equals(that.staticIpArn)) return false;
            return this.staticIpName.equals(that.staticIpName);
        }

        @Override
        public final int hashCode() {
            int result = this.staticIpArn.hashCode();
            result = 31 * result + (this.staticIpName.hashCode());
            return result;
        }
    }
}
