package software.amazon.awscdk.interfaces.location;

/**
 * A reference to a APIKey resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.location.*;
 * APIKeyReference aPIKeyReference = APIKeyReference.builder()
 *         .apiKeyArn("apiKeyArn")
 *         .keyName("keyName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.611Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_location.APIKeyReference")
@software.amazon.jsii.Jsii.Proxy(APIKeyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface APIKeyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the APIKey resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiKeyArn();

    /**
     * The KeyName of the APIKey resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyName();

    /**
     * @return a {@link Builder} of {@link APIKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link APIKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<APIKeyReference> {
        java.lang.String apiKeyArn;
        java.lang.String keyName;

        /**
         * Sets the value of {@link APIKeyReference#getApiKeyArn}
         * @param apiKeyArn The ARN of the APIKey resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyArn(java.lang.String apiKeyArn) {
            this.apiKeyArn = apiKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link APIKeyReference#getKeyName}
         * @param keyName The KeyName of the APIKey resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link APIKeyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public APIKeyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link APIKeyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements APIKeyReference {
        private final java.lang.String apiKeyArn;
        private final java.lang.String keyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeyArn = software.amazon.jsii.Kernel.get(this, "apiKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeyArn = java.util.Objects.requireNonNull(builder.apiKeyArn, "apiKeyArn is required");
            this.keyName = java.util.Objects.requireNonNull(builder.keyName, "keyName is required");
        }

        @Override
        public final java.lang.String getApiKeyArn() {
            return this.apiKeyArn;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiKeyArn", om.valueToTree(this.getApiKeyArn()));
            data.set("keyName", om.valueToTree(this.getKeyName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_location.APIKeyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            APIKeyReference.Jsii$Proxy that = (APIKeyReference.Jsii$Proxy) o;

            if (!apiKeyArn.equals(that.apiKeyArn)) return false;
            return this.keyName.equals(that.keyName);
        }

        @Override
        public final int hashCode() {
            int result = this.apiKeyArn.hashCode();
            result = 31 * result + (this.keyName.hashCode());
            return result;
        }
    }
}
