package software.amazon.awscdk.interfaces.location;

/**
 * A reference to a Map resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.location.*;
 * MapReference mapReference = MapReference.builder()
 *         .mapArn("mapArn")
 *         .mapName("mapName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.614Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_location.MapReference")
@software.amazon.jsii.Jsii.Proxy(MapReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MapReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMapArn();

    /**
     * The MapName of the Map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMapName();

    /**
     * @return a {@link Builder} of {@link MapReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MapReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MapReference> {
        java.lang.String mapArn;
        java.lang.String mapName;

        /**
         * Sets the value of {@link MapReference#getMapArn}
         * @param mapArn The ARN of the Map resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapArn(java.lang.String mapArn) {
            this.mapArn = mapArn;
            return this;
        }

        /**
         * Sets the value of {@link MapReference#getMapName}
         * @param mapName The MapName of the Map resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapName(java.lang.String mapName) {
            this.mapName = mapName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MapReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MapReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MapReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapReference {
        private final java.lang.String mapArn;
        private final java.lang.String mapName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mapArn = software.amazon.jsii.Kernel.get(this, "mapArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mapName = software.amazon.jsii.Kernel.get(this, "mapName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mapArn = java.util.Objects.requireNonNull(builder.mapArn, "mapArn is required");
            this.mapName = java.util.Objects.requireNonNull(builder.mapName, "mapName is required");
        }

        @Override
        public final java.lang.String getMapArn() {
            return this.mapArn;
        }

        @Override
        public final java.lang.String getMapName() {
            return this.mapName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mapArn", om.valueToTree(this.getMapArn()));
            data.set("mapName", om.valueToTree(this.getMapName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_location.MapReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MapReference.Jsii$Proxy that = (MapReference.Jsii$Proxy) o;

            if (!mapArn.equals(that.mapArn)) return false;
            return this.mapName.equals(that.mapName);
        }

        @Override
        public final int hashCode() {
            int result = this.mapArn.hashCode();
            result = 31 * result + (this.mapName.hashCode());
            return result;
        }
    }
}
