package software.amazon.awscdk.interfaces.location;

/**
 * A reference to a RouteCalculator resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.location.*;
 * RouteCalculatorReference routeCalculatorReference = RouteCalculatorReference.builder()
 *         .calculatorName("calculatorName")
 *         .routeCalculatorArn("routeCalculatorArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.615Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_location.RouteCalculatorReference")
@software.amazon.jsii.Jsii.Proxy(RouteCalculatorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteCalculatorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CalculatorName of the RouteCalculator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCalculatorName();

    /**
     * The ARN of the RouteCalculator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteCalculatorArn();

    /**
     * @return a {@link Builder} of {@link RouteCalculatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteCalculatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteCalculatorReference> {
        java.lang.String calculatorName;
        java.lang.String routeCalculatorArn;

        /**
         * Sets the value of {@link RouteCalculatorReference#getCalculatorName}
         * @param calculatorName The CalculatorName of the RouteCalculator resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder calculatorName(java.lang.String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        /**
         * Sets the value of {@link RouteCalculatorReference#getRouteCalculatorArn}
         * @param routeCalculatorArn The ARN of the RouteCalculator resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeCalculatorArn(java.lang.String routeCalculatorArn) {
            this.routeCalculatorArn = routeCalculatorArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteCalculatorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteCalculatorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteCalculatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteCalculatorReference {
        private final java.lang.String calculatorName;
        private final java.lang.String routeCalculatorArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.calculatorName = software.amazon.jsii.Kernel.get(this, "calculatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeCalculatorArn = software.amazon.jsii.Kernel.get(this, "routeCalculatorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.calculatorName = java.util.Objects.requireNonNull(builder.calculatorName, "calculatorName is required");
            this.routeCalculatorArn = java.util.Objects.requireNonNull(builder.routeCalculatorArn, "routeCalculatorArn is required");
        }

        @Override
        public final java.lang.String getCalculatorName() {
            return this.calculatorName;
        }

        @Override
        public final java.lang.String getRouteCalculatorArn() {
            return this.routeCalculatorArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("calculatorName", om.valueToTree(this.getCalculatorName()));
            data.set("routeCalculatorArn", om.valueToTree(this.getRouteCalculatorArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_location.RouteCalculatorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteCalculatorReference.Jsii$Proxy that = (RouteCalculatorReference.Jsii$Proxy) o;

            if (!calculatorName.equals(that.calculatorName)) return false;
            return this.routeCalculatorArn.equals(that.routeCalculatorArn);
        }

        @Override
        public final int hashCode() {
            int result = this.calculatorName.hashCode();
            result = 31 * result + (this.routeCalculatorArn.hashCode());
            return result;
        }
    }
}
