package software.amazon.awscdk.interfaces.location;

/**
 * A reference to a Tracker resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.location.*;
 * TrackerReference trackerReference = TrackerReference.builder()
 *         .trackerArn("trackerArn")
 *         .trackerName("trackerName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.615Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_location.TrackerReference")
@software.amazon.jsii.Jsii.Proxy(TrackerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrackerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Tracker resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrackerArn();

    /**
     * The TrackerName of the Tracker resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrackerName();

    /**
     * @return a {@link Builder} of {@link TrackerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrackerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrackerReference> {
        java.lang.String trackerArn;
        java.lang.String trackerName;

        /**
         * Sets the value of {@link TrackerReference#getTrackerArn}
         * @param trackerArn The ARN of the Tracker resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackerArn(java.lang.String trackerArn) {
            this.trackerArn = trackerArn;
            return this;
        }

        /**
         * Sets the value of {@link TrackerReference#getTrackerName}
         * @param trackerName The TrackerName of the Tracker resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackerName(java.lang.String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrackerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrackerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrackerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrackerReference {
        private final java.lang.String trackerArn;
        private final java.lang.String trackerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.trackerArn = software.amazon.jsii.Kernel.get(this, "trackerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trackerName = software.amazon.jsii.Kernel.get(this, "trackerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.trackerArn = java.util.Objects.requireNonNull(builder.trackerArn, "trackerArn is required");
            this.trackerName = java.util.Objects.requireNonNull(builder.trackerName, "trackerName is required");
        }

        @Override
        public final java.lang.String getTrackerArn() {
            return this.trackerArn;
        }

        @Override
        public final java.lang.String getTrackerName() {
            return this.trackerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("trackerArn", om.valueToTree(this.getTrackerArn()));
            data.set("trackerName", om.valueToTree(this.getTrackerName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_location.TrackerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrackerReference.Jsii$Proxy that = (TrackerReference.Jsii$Proxy) o;

            if (!trackerArn.equals(that.trackerArn)) return false;
            return this.trackerName.equals(that.trackerName);
        }

        @Override
        public final int hashCode() {
            int result = this.trackerArn.hashCode();
            result = 31 * result + (this.trackerName.hashCode());
            return result;
        }
    }
}
