package software.amazon.awscdk.interfaces.logs;

/**
 * A reference to a DeliveryDestination resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.logs.*;
 * DeliveryDestinationReference deliveryDestinationReference = DeliveryDestinationReference.builder()
 *         .deliveryDestinationArn("deliveryDestinationArn")
 *         .deliveryDestinationName("deliveryDestinationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.616Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_logs.DeliveryDestinationReference")
@software.amazon.jsii.Jsii.Proxy(DeliveryDestinationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeliveryDestinationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DeliveryDestination resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryDestinationArn();

    /**
     * The Name of the DeliveryDestination resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryDestinationName();

    /**
     * @return a {@link Builder} of {@link DeliveryDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryDestinationReference> {
        java.lang.String deliveryDestinationArn;
        java.lang.String deliveryDestinationName;

        /**
         * Sets the value of {@link DeliveryDestinationReference#getDeliveryDestinationArn}
         * @param deliveryDestinationArn The ARN of the DeliveryDestination resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryDestinationArn(java.lang.String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryDestinationReference#getDeliveryDestinationName}
         * @param deliveryDestinationName The Name of the DeliveryDestination resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryDestinationName(java.lang.String deliveryDestinationName) {
            this.deliveryDestinationName = deliveryDestinationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryDestinationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeliveryDestinationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryDestinationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryDestinationReference {
        private final java.lang.String deliveryDestinationArn;
        private final java.lang.String deliveryDestinationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryDestinationArn = software.amazon.jsii.Kernel.get(this, "deliveryDestinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryDestinationName = software.amazon.jsii.Kernel.get(this, "deliveryDestinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryDestinationArn = java.util.Objects.requireNonNull(builder.deliveryDestinationArn, "deliveryDestinationArn is required");
            this.deliveryDestinationName = java.util.Objects.requireNonNull(builder.deliveryDestinationName, "deliveryDestinationName is required");
        }

        @Override
        public final java.lang.String getDeliveryDestinationArn() {
            return this.deliveryDestinationArn;
        }

        @Override
        public final java.lang.String getDeliveryDestinationName() {
            return this.deliveryDestinationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deliveryDestinationArn", om.valueToTree(this.getDeliveryDestinationArn()));
            data.set("deliveryDestinationName", om.valueToTree(this.getDeliveryDestinationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_logs.DeliveryDestinationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryDestinationReference.Jsii$Proxy that = (DeliveryDestinationReference.Jsii$Proxy) o;

            if (!deliveryDestinationArn.equals(that.deliveryDestinationArn)) return false;
            return this.deliveryDestinationName.equals(that.deliveryDestinationName);
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryDestinationArn.hashCode();
            result = 31 * result + (this.deliveryDestinationName.hashCode());
            return result;
        }
    }
}
