package software.amazon.awscdk.interfaces.logs;

/**
 * A reference to a LogAnomalyDetector resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.logs.*;
 * LogAnomalyDetectorReference logAnomalyDetectorReference = LogAnomalyDetectorReference.builder()
 *         .anomalyDetectorArn("anomalyDetectorArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.622Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_logs.LogAnomalyDetectorReference")
@software.amazon.jsii.Jsii.Proxy(LogAnomalyDetectorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogAnomalyDetectorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AnomalyDetectorArn of the LogAnomalyDetector resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAnomalyDetectorArn();

    /**
     * @return a {@link Builder} of {@link LogAnomalyDetectorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogAnomalyDetectorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogAnomalyDetectorReference> {
        java.lang.String anomalyDetectorArn;

        /**
         * Sets the value of {@link LogAnomalyDetectorReference#getAnomalyDetectorArn}
         * @param anomalyDetectorArn The AnomalyDetectorArn of the LogAnomalyDetector resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyDetectorArn(java.lang.String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogAnomalyDetectorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogAnomalyDetectorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogAnomalyDetectorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogAnomalyDetectorReference {
        private final java.lang.String anomalyDetectorArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.anomalyDetectorArn = software.amazon.jsii.Kernel.get(this, "anomalyDetectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.anomalyDetectorArn = java.util.Objects.requireNonNull(builder.anomalyDetectorArn, "anomalyDetectorArn is required");
        }

        @Override
        public final java.lang.String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("anomalyDetectorArn", om.valueToTree(this.getAnomalyDetectorArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_logs.LogAnomalyDetectorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogAnomalyDetectorReference.Jsii$Proxy that = (LogAnomalyDetectorReference.Jsii$Proxy) o;

            return this.anomalyDetectorArn.equals(that.anomalyDetectorArn);
        }

        @Override
        public final int hashCode() {
            int result = this.anomalyDetectorArn.hashCode();
            return result;
        }
    }
}
