package software.amazon.awscdk.interfaces.mediaconnect;

/**
 * A reference to a RouterNetworkInterface resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediaconnect.*;
 * RouterNetworkInterfaceReference routerNetworkInterfaceReference = RouterNetworkInterfaceReference.builder()
 *         .routerNetworkInterfaceArn("routerNetworkInterfaceArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.648Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediaconnect.RouterNetworkInterfaceReference")
@software.amazon.jsii.Jsii.Proxy(RouterNetworkInterfaceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouterNetworkInterfaceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the RouterNetworkInterface resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouterNetworkInterfaceArn();

    /**
     * @return a {@link Builder} of {@link RouterNetworkInterfaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouterNetworkInterfaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouterNetworkInterfaceReference> {
        java.lang.String routerNetworkInterfaceArn;

        /**
         * Sets the value of {@link RouterNetworkInterfaceReference#getRouterNetworkInterfaceArn}
         * @param routerNetworkInterfaceArn The Arn of the RouterNetworkInterface resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routerNetworkInterfaceArn(java.lang.String routerNetworkInterfaceArn) {
            this.routerNetworkInterfaceArn = routerNetworkInterfaceArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouterNetworkInterfaceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouterNetworkInterfaceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouterNetworkInterfaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouterNetworkInterfaceReference {
        private final java.lang.String routerNetworkInterfaceArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routerNetworkInterfaceArn = software.amazon.jsii.Kernel.get(this, "routerNetworkInterfaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routerNetworkInterfaceArn = java.util.Objects.requireNonNull(builder.routerNetworkInterfaceArn, "routerNetworkInterfaceArn is required");
        }

        @Override
        public final java.lang.String getRouterNetworkInterfaceArn() {
            return this.routerNetworkInterfaceArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routerNetworkInterfaceArn", om.valueToTree(this.getRouterNetworkInterfaceArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediaconnect.RouterNetworkInterfaceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouterNetworkInterfaceReference.Jsii$Proxy that = (RouterNetworkInterfaceReference.Jsii$Proxy) o;

            return this.routerNetworkInterfaceArn.equals(that.routerNetworkInterfaceArn);
        }

        @Override
        public final int hashCode() {
            int result = this.routerNetworkInterfaceArn.hashCode();
            return result;
        }
    }
}
