package software.amazon.awscdk.interfaces.mediaconvert;

/**
 * A reference to a Queue resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediaconvert.*;
 * QueueReference queueReference = QueueReference.builder()
 *         .queueArn("queueArn")
 *         .queueId("queueId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.650Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediaconvert.QueueReference")
@software.amazon.jsii.Jsii.Proxy(QueueReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueueReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Queue resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueArn();

    /**
     * The Id of the Queue resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueId();

    /**
     * @return a {@link Builder} of {@link QueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueueReference> {
        java.lang.String queueArn;
        java.lang.String queueId;

        /**
         * Sets the value of {@link QueueReference#getQueueArn}
         * @param queueArn The ARN of the Queue resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueArn(java.lang.String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        /**
         * Sets the value of {@link QueueReference#getQueueId}
         * @param queueId The Id of the Queue resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueId(java.lang.String queueId) {
            this.queueId = queueId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueueReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueueReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueReference {
        private final java.lang.String queueArn;
        private final java.lang.String queueId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queueArn = software.amazon.jsii.Kernel.get(this, "queueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queueId = software.amazon.jsii.Kernel.get(this, "queueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queueArn = java.util.Objects.requireNonNull(builder.queueArn, "queueArn is required");
            this.queueId = java.util.Objects.requireNonNull(builder.queueId, "queueId is required");
        }

        @Override
        public final java.lang.String getQueueArn() {
            return this.queueArn;
        }

        @Override
        public final java.lang.String getQueueId() {
            return this.queueId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queueArn", om.valueToTree(this.getQueueArn()));
            data.set("queueId", om.valueToTree(this.getQueueId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediaconvert.QueueReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueReference.Jsii$Proxy that = (QueueReference.Jsii$Proxy) o;

            if (!queueArn.equals(that.queueArn)) return false;
            return this.queueId.equals(that.queueId);
        }

        @Override
        public final int hashCode() {
            int result = this.queueArn.hashCode();
            result = 31 * result + (this.queueId.hashCode());
            return result;
        }
    }
}
