package software.amazon.awscdk.interfaces.medialive;

/**
 * A reference to a Input resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.medialive.*;
 * InputReference inputReference = InputReference.builder()
 *         .inputArn("inputArn")
 *         .inputId("inputId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.656Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_medialive.InputReference")
@software.amazon.jsii.Jsii.Proxy(InputReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InputReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Input resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInputArn();

    /**
     * The Id of the Input resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInputId();

    /**
     * @return a {@link Builder} of {@link InputReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InputReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InputReference> {
        java.lang.String inputArn;
        java.lang.String inputId;

        /**
         * Sets the value of {@link InputReference#getInputArn}
         * @param inputArn The ARN of the Input resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArn(java.lang.String inputArn) {
            this.inputArn = inputArn;
            return this;
        }

        /**
         * Sets the value of {@link InputReference#getInputId}
         * @param inputId The Id of the Input resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputId(java.lang.String inputId) {
            this.inputId = inputId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InputReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InputReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InputReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputReference {
        private final java.lang.String inputArn;
        private final java.lang.String inputId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputArn = software.amazon.jsii.Kernel.get(this, "inputArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputId = software.amazon.jsii.Kernel.get(this, "inputId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputArn = java.util.Objects.requireNonNull(builder.inputArn, "inputArn is required");
            this.inputId = java.util.Objects.requireNonNull(builder.inputId, "inputId is required");
        }

        @Override
        public final java.lang.String getInputArn() {
            return this.inputArn;
        }

        @Override
        public final java.lang.String getInputId() {
            return this.inputId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputArn", om.valueToTree(this.getInputArn()));
            data.set("inputId", om.valueToTree(this.getInputId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_medialive.InputReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InputReference.Jsii$Proxy that = (InputReference.Jsii$Proxy) o;

            if (!inputArn.equals(that.inputArn)) return false;
            return this.inputId.equals(that.inputId);
        }

        @Override
        public final int hashCode() {
            int result = this.inputArn.hashCode();
            result = 31 * result + (this.inputId.hashCode());
            return result;
        }
    }
}
