package software.amazon.awscdk.interfaces.mediapackage;

/**
 * A reference to a PackagingConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediapackage.*;
 * PackagingConfigurationReference packagingConfigurationReference = PackagingConfigurationReference.builder()
 *         .packagingConfigurationArn("packagingConfigurationArn")
 *         .packagingConfigurationId("packagingConfigurationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.661Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediapackage.PackagingConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(PackagingConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PackagingConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PackagingConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackagingConfigurationArn();

    /**
     * The Id of the PackagingConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackagingConfigurationId();

    /**
     * @return a {@link Builder} of {@link PackagingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PackagingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PackagingConfigurationReference> {
        java.lang.String packagingConfigurationArn;
        java.lang.String packagingConfigurationId;

        /**
         * Sets the value of {@link PackagingConfigurationReference#getPackagingConfigurationArn}
         * @param packagingConfigurationArn The ARN of the PackagingConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packagingConfigurationArn(java.lang.String packagingConfigurationArn) {
            this.packagingConfigurationArn = packagingConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link PackagingConfigurationReference#getPackagingConfigurationId}
         * @param packagingConfigurationId The Id of the PackagingConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packagingConfigurationId(java.lang.String packagingConfigurationId) {
            this.packagingConfigurationId = packagingConfigurationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PackagingConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PackagingConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PackagingConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PackagingConfigurationReference {
        private final java.lang.String packagingConfigurationArn;
        private final java.lang.String packagingConfigurationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.packagingConfigurationArn = software.amazon.jsii.Kernel.get(this, "packagingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packagingConfigurationId = software.amazon.jsii.Kernel.get(this, "packagingConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.packagingConfigurationArn = java.util.Objects.requireNonNull(builder.packagingConfigurationArn, "packagingConfigurationArn is required");
            this.packagingConfigurationId = java.util.Objects.requireNonNull(builder.packagingConfigurationId, "packagingConfigurationId is required");
        }

        @Override
        public final java.lang.String getPackagingConfigurationArn() {
            return this.packagingConfigurationArn;
        }

        @Override
        public final java.lang.String getPackagingConfigurationId() {
            return this.packagingConfigurationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("packagingConfigurationArn", om.valueToTree(this.getPackagingConfigurationArn()));
            data.set("packagingConfigurationId", om.valueToTree(this.getPackagingConfigurationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediapackage.PackagingConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PackagingConfigurationReference.Jsii$Proxy that = (PackagingConfigurationReference.Jsii$Proxy) o;

            if (!packagingConfigurationArn.equals(that.packagingConfigurationArn)) return false;
            return this.packagingConfigurationId.equals(that.packagingConfigurationId);
        }

        @Override
        public final int hashCode() {
            int result = this.packagingConfigurationArn.hashCode();
            result = 31 * result + (this.packagingConfigurationId.hashCode());
            return result;
        }
    }
}
