package software.amazon.awscdk.interfaces.mediatailor;

/**
 * A reference to a PlaybackConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediatailor.*;
 * PlaybackConfigurationReference playbackConfigurationReference = PlaybackConfigurationReference.builder()
 *         .playbackConfigurationArn("playbackConfigurationArn")
 *         .playbackConfigurationName("playbackConfigurationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.679Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediatailor.PlaybackConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(PlaybackConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PlaybackConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PlaybackConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPlaybackConfigurationArn();

    /**
     * The Name of the PlaybackConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPlaybackConfigurationName();

    /**
     * @return a {@link Builder} of {@link PlaybackConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PlaybackConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PlaybackConfigurationReference> {
        java.lang.String playbackConfigurationArn;
        java.lang.String playbackConfigurationName;

        /**
         * Sets the value of {@link PlaybackConfigurationReference#getPlaybackConfigurationArn}
         * @param playbackConfigurationArn The ARN of the PlaybackConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder playbackConfigurationArn(java.lang.String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link PlaybackConfigurationReference#getPlaybackConfigurationName}
         * @param playbackConfigurationName The Name of the PlaybackConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder playbackConfigurationName(java.lang.String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PlaybackConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PlaybackConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PlaybackConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlaybackConfigurationReference {
        private final java.lang.String playbackConfigurationArn;
        private final java.lang.String playbackConfigurationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.playbackConfigurationArn = software.amazon.jsii.Kernel.get(this, "playbackConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.playbackConfigurationName = software.amazon.jsii.Kernel.get(this, "playbackConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.playbackConfigurationArn = java.util.Objects.requireNonNull(builder.playbackConfigurationArn, "playbackConfigurationArn is required");
            this.playbackConfigurationName = java.util.Objects.requireNonNull(builder.playbackConfigurationName, "playbackConfigurationName is required");
        }

        @Override
        public final java.lang.String getPlaybackConfigurationArn() {
            return this.playbackConfigurationArn;
        }

        @Override
        public final java.lang.String getPlaybackConfigurationName() {
            return this.playbackConfigurationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("playbackConfigurationArn", om.valueToTree(this.getPlaybackConfigurationArn()));
            data.set("playbackConfigurationName", om.valueToTree(this.getPlaybackConfigurationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediatailor.PlaybackConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PlaybackConfigurationReference.Jsii$Proxy that = (PlaybackConfigurationReference.Jsii$Proxy) o;

            if (!playbackConfigurationArn.equals(that.playbackConfigurationArn)) return false;
            return this.playbackConfigurationName.equals(that.playbackConfigurationName);
        }

        @Override
        public final int hashCode() {
            int result = this.playbackConfigurationArn.hashCode();
            result = 31 * result + (this.playbackConfigurationName.hashCode());
            return result;
        }
    }
}
