package software.amazon.awscdk.interfaces.msk;

/**
 * A reference to a Replicator resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.msk.*;
 * ReplicatorReference replicatorReference = ReplicatorReference.builder()
 *         .replicatorArn("replicatorArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.688Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_msk.ReplicatorReference")
@software.amazon.jsii.Jsii.Proxy(ReplicatorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReplicatorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ReplicatorArn of the Replicator resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicatorArn();

    /**
     * @return a {@link Builder} of {@link ReplicatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReplicatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReplicatorReference> {
        java.lang.String replicatorArn;

        /**
         * Sets the value of {@link ReplicatorReference#getReplicatorArn}
         * @param replicatorArn The ReplicatorArn of the Replicator resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicatorArn(java.lang.String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReplicatorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReplicatorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReplicatorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicatorReference {
        private final java.lang.String replicatorArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.replicatorArn = software.amazon.jsii.Kernel.get(this, "replicatorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.replicatorArn = java.util.Objects.requireNonNull(builder.replicatorArn, "replicatorArn is required");
        }

        @Override
        public final java.lang.String getReplicatorArn() {
            return this.replicatorArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("replicatorArn", om.valueToTree(this.getReplicatorArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_msk.ReplicatorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReplicatorReference.Jsii$Proxy that = (ReplicatorReference.Jsii$Proxy) o;

            return this.replicatorArn.equals(that.replicatorArn);
        }

        @Override
        public final int hashCode() {
            int result = this.replicatorArn.hashCode();
            return result;
        }
    }
}
