package software.amazon.awscdk.interfaces.networkmanager;

/**
 * A reference to a ConnectPeer resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.networkmanager.*;
 * ConnectPeerReference connectPeerReference = ConnectPeerReference.builder()
 *         .connectPeerId("connectPeerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.698Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_networkmanager.ConnectPeerReference")
@software.amazon.jsii.Jsii.Proxy(ConnectPeerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectPeerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ConnectPeerId of the ConnectPeer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectPeerId();

    /**
     * @return a {@link Builder} of {@link ConnectPeerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectPeerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectPeerReference> {
        java.lang.String connectPeerId;

        /**
         * Sets the value of {@link ConnectPeerReference#getConnectPeerId}
         * @param connectPeerId The ConnectPeerId of the ConnectPeer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectPeerId(java.lang.String connectPeerId) {
            this.connectPeerId = connectPeerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectPeerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectPeerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectPeerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectPeerReference {
        private final java.lang.String connectPeerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectPeerId = software.amazon.jsii.Kernel.get(this, "connectPeerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectPeerId = java.util.Objects.requireNonNull(builder.connectPeerId, "connectPeerId is required");
        }

        @Override
        public final java.lang.String getConnectPeerId() {
            return this.connectPeerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectPeerId", om.valueToTree(this.getConnectPeerId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_networkmanager.ConnectPeerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectPeerReference.Jsii$Proxy that = (ConnectPeerReference.Jsii$Proxy) o;

            return this.connectPeerId.equals(that.connectPeerId);
        }

        @Override
        public final int hashCode() {
            int result = this.connectPeerId.hashCode();
            return result;
        }
    }
}
