package software.amazon.awscdk.interfaces.networkmanager;

/**
 * A reference to a GlobalNetwork resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.networkmanager.*;
 * GlobalNetworkReference globalNetworkReference = GlobalNetworkReference.builder()
 *         .globalNetworkArn("globalNetworkArn")
 *         .globalNetworkId("globalNetworkId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.700Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_networkmanager.GlobalNetworkReference")
@software.amazon.jsii.Jsii.Proxy(GlobalNetworkReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GlobalNetworkReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the GlobalNetwork resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkArn();

    /**
     * The Id of the GlobalNetwork resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkId();

    /**
     * @return a {@link Builder} of {@link GlobalNetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GlobalNetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GlobalNetworkReference> {
        java.lang.String globalNetworkArn;
        java.lang.String globalNetworkId;

        /**
         * Sets the value of {@link GlobalNetworkReference#getGlobalNetworkArn}
         * @param globalNetworkArn The ARN of the GlobalNetwork resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkArn(java.lang.String globalNetworkArn) {
            this.globalNetworkArn = globalNetworkArn;
            return this;
        }

        /**
         * Sets the value of {@link GlobalNetworkReference#getGlobalNetworkId}
         * @param globalNetworkId The Id of the GlobalNetwork resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkId(java.lang.String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GlobalNetworkReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GlobalNetworkReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GlobalNetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalNetworkReference {
        private final java.lang.String globalNetworkArn;
        private final java.lang.String globalNetworkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.globalNetworkArn = software.amazon.jsii.Kernel.get(this, "globalNetworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalNetworkId = software.amazon.jsii.Kernel.get(this, "globalNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.globalNetworkArn = java.util.Objects.requireNonNull(builder.globalNetworkArn, "globalNetworkArn is required");
            this.globalNetworkId = java.util.Objects.requireNonNull(builder.globalNetworkId, "globalNetworkId is required");
        }

        @Override
        public final java.lang.String getGlobalNetworkArn() {
            return this.globalNetworkArn;
        }

        @Override
        public final java.lang.String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("globalNetworkArn", om.valueToTree(this.getGlobalNetworkArn()));
            data.set("globalNetworkId", om.valueToTree(this.getGlobalNetworkId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_networkmanager.GlobalNetworkReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GlobalNetworkReference.Jsii$Proxy that = (GlobalNetworkReference.Jsii$Proxy) o;

            if (!globalNetworkArn.equals(that.globalNetworkArn)) return false;
            return this.globalNetworkId.equals(that.globalNetworkId);
        }

        @Override
        public final int hashCode() {
            int result = this.globalNetworkArn.hashCode();
            result = 31 * result + (this.globalNetworkId.hashCode());
            return result;
        }
    }
}
