package software.amazon.awscdk.interfaces.networkmanager;

/**
 * A reference to a TransitGatewayRegistration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.networkmanager.*;
 * TransitGatewayRegistrationReference transitGatewayRegistrationReference = TransitGatewayRegistrationReference.builder()
 *         .globalNetworkId("globalNetworkId")
 *         .transitGatewayArn("transitGatewayArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.716Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_networkmanager.TransitGatewayRegistrationReference")
@software.amazon.jsii.Jsii.Proxy(TransitGatewayRegistrationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransitGatewayRegistrationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The GlobalNetworkId of the TransitGatewayRegistration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkId();

    /**
     * The TransitGatewayArn of the TransitGatewayRegistration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayArn();

    /**
     * @return a {@link Builder} of {@link TransitGatewayRegistrationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransitGatewayRegistrationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransitGatewayRegistrationReference> {
        java.lang.String globalNetworkId;
        java.lang.String transitGatewayArn;

        /**
         * Sets the value of {@link TransitGatewayRegistrationReference#getGlobalNetworkId}
         * @param globalNetworkId The GlobalNetworkId of the TransitGatewayRegistration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkId(java.lang.String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link TransitGatewayRegistrationReference#getTransitGatewayArn}
         * @param transitGatewayArn The TransitGatewayArn of the TransitGatewayRegistration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayArn(java.lang.String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransitGatewayRegistrationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransitGatewayRegistrationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransitGatewayRegistrationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitGatewayRegistrationReference {
        private final java.lang.String globalNetworkId;
        private final java.lang.String transitGatewayArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.globalNetworkId = software.amazon.jsii.Kernel.get(this, "globalNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayArn = software.amazon.jsii.Kernel.get(this, "transitGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.globalNetworkId = java.util.Objects.requireNonNull(builder.globalNetworkId, "globalNetworkId is required");
            this.transitGatewayArn = java.util.Objects.requireNonNull(builder.transitGatewayArn, "transitGatewayArn is required");
        }

        @Override
        public final java.lang.String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        public final java.lang.String getTransitGatewayArn() {
            return this.transitGatewayArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("globalNetworkId", om.valueToTree(this.getGlobalNetworkId()));
            data.set("transitGatewayArn", om.valueToTree(this.getTransitGatewayArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_networkmanager.TransitGatewayRegistrationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransitGatewayRegistrationReference.Jsii$Proxy that = (TransitGatewayRegistrationReference.Jsii$Proxy) o;

            if (!globalNetworkId.equals(that.globalNetworkId)) return false;
            return this.transitGatewayArn.equals(that.transitGatewayArn);
        }

        @Override
        public final int hashCode() {
            int result = this.globalNetworkId.hashCode();
            result = 31 * result + (this.transitGatewayArn.hashCode());
            return result;
        }
    }
}
