package software.amazon.awscdk.interfaces.notifications;

/**
 * A reference to a ManagedNotificationAccountContactAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.notifications.*;
 * ManagedNotificationAccountContactAssociationReference managedNotificationAccountContactAssociationReference = ManagedNotificationAccountContactAssociationReference.builder()
 *         .contactIdentifier("contactIdentifier")
 *         .managedNotificationConfigurationArn("managedNotificationConfigurationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.722Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_notifications.ManagedNotificationAccountContactAssociationReference")
@software.amazon.jsii.Jsii.Proxy(ManagedNotificationAccountContactAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedNotificationAccountContactAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ContactIdentifier of the ManagedNotificationAccountContactAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContactIdentifier();

    /**
     * The ManagedNotificationConfigurationArn of the ManagedNotificationAccountContactAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getManagedNotificationConfigurationArn();

    /**
     * @return a {@link Builder} of {@link ManagedNotificationAccountContactAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ManagedNotificationAccountContactAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ManagedNotificationAccountContactAssociationReference> {
        java.lang.String contactIdentifier;
        java.lang.String managedNotificationConfigurationArn;

        /**
         * Sets the value of {@link ManagedNotificationAccountContactAssociationReference#getContactIdentifier}
         * @param contactIdentifier The ContactIdentifier of the ManagedNotificationAccountContactAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactIdentifier(java.lang.String contactIdentifier) {
            this.contactIdentifier = contactIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ManagedNotificationAccountContactAssociationReference#getManagedNotificationConfigurationArn}
         * @param managedNotificationConfigurationArn The ManagedNotificationConfigurationArn of the ManagedNotificationAccountContactAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedNotificationConfigurationArn(java.lang.String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedNotificationAccountContactAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ManagedNotificationAccountContactAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ManagedNotificationAccountContactAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedNotificationAccountContactAssociationReference {
        private final java.lang.String contactIdentifier;
        private final java.lang.String managedNotificationConfigurationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contactIdentifier = software.amazon.jsii.Kernel.get(this, "contactIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managedNotificationConfigurationArn = software.amazon.jsii.Kernel.get(this, "managedNotificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contactIdentifier = java.util.Objects.requireNonNull(builder.contactIdentifier, "contactIdentifier is required");
            this.managedNotificationConfigurationArn = java.util.Objects.requireNonNull(builder.managedNotificationConfigurationArn, "managedNotificationConfigurationArn is required");
        }

        @Override
        public final java.lang.String getContactIdentifier() {
            return this.contactIdentifier;
        }

        @Override
        public final java.lang.String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("contactIdentifier", om.valueToTree(this.getContactIdentifier()));
            data.set("managedNotificationConfigurationArn", om.valueToTree(this.getManagedNotificationConfigurationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_notifications.ManagedNotificationAccountContactAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManagedNotificationAccountContactAssociationReference.Jsii$Proxy that = (ManagedNotificationAccountContactAssociationReference.Jsii$Proxy) o;

            if (!contactIdentifier.equals(that.contactIdentifier)) return false;
            return this.managedNotificationConfigurationArn.equals(that.managedNotificationConfigurationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.contactIdentifier.hashCode();
            result = 31 * result + (this.managedNotificationConfigurationArn.hashCode());
            return result;
        }
    }
}
