package software.amazon.awscdk.interfaces.notifications;

/**
 * A reference to a OrganizationalUnitAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.notifications.*;
 * OrganizationalUnitAssociationReference organizationalUnitAssociationReference = OrganizationalUnitAssociationReference.builder()
 *         .notificationConfigurationArn("notificationConfigurationArn")
 *         .organizationalUnitId("organizationalUnitId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.723Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_notifications.OrganizationalUnitAssociationReference")
@software.amazon.jsii.Jsii.Proxy(OrganizationalUnitAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrganizationalUnitAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The NotificationConfigurationArn of the OrganizationalUnitAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotificationConfigurationArn();

    /**
     * The OrganizationalUnitId of the OrganizationalUnitAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationalUnitId();

    /**
     * @return a {@link Builder} of {@link OrganizationalUnitAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrganizationalUnitAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrganizationalUnitAssociationReference> {
        java.lang.String notificationConfigurationArn;
        java.lang.String organizationalUnitId;

        /**
         * Sets the value of {@link OrganizationalUnitAssociationReference#getNotificationConfigurationArn}
         * @param notificationConfigurationArn The NotificationConfigurationArn of the OrganizationalUnitAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfigurationArn(java.lang.String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link OrganizationalUnitAssociationReference#getOrganizationalUnitId}
         * @param organizationalUnitId The OrganizationalUnitId of the OrganizationalUnitAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationalUnitId(java.lang.String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrganizationalUnitAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrganizationalUnitAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrganizationalUnitAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationalUnitAssociationReference {
        private final java.lang.String notificationConfigurationArn;
        private final java.lang.String organizationalUnitId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.notificationConfigurationArn = software.amazon.jsii.Kernel.get(this, "notificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationalUnitId = software.amazon.jsii.Kernel.get(this, "organizationalUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.notificationConfigurationArn = java.util.Objects.requireNonNull(builder.notificationConfigurationArn, "notificationConfigurationArn is required");
            this.organizationalUnitId = java.util.Objects.requireNonNull(builder.organizationalUnitId, "organizationalUnitId is required");
        }

        @Override
        public final java.lang.String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        @Override
        public final java.lang.String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("notificationConfigurationArn", om.valueToTree(this.getNotificationConfigurationArn()));
            data.set("organizationalUnitId", om.valueToTree(this.getOrganizationalUnitId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_notifications.OrganizationalUnitAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrganizationalUnitAssociationReference.Jsii$Proxy that = (OrganizationalUnitAssociationReference.Jsii$Proxy) o;

            if (!notificationConfigurationArn.equals(that.notificationConfigurationArn)) return false;
            return this.organizationalUnitId.equals(that.organizationalUnitId);
        }

        @Override
        public final int hashCode() {
            int result = this.notificationConfigurationArn.hashCode();
            result = 31 * result + (this.organizationalUnitId.hashCode());
            return result;
        }
    }
}
