package software.amazon.awscdk.interfaces.organizations;

/**
 * A reference to a Organization resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.organizations.*;
 * OrganizationReference organizationReference = OrganizationReference.builder()
 *         .organizationArn("organizationArn")
 *         .organizationId("organizationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.758Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_organizations.OrganizationReference")
@software.amazon.jsii.Jsii.Proxy(OrganizationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrganizationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Organization resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationArn();

    /**
     * The Id of the Organization resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationId();

    /**
     * @return a {@link Builder} of {@link OrganizationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrganizationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrganizationReference> {
        java.lang.String organizationArn;
        java.lang.String organizationId;

        /**
         * Sets the value of {@link OrganizationReference#getOrganizationArn}
         * @param organizationArn The ARN of the Organization resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationArn(java.lang.String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        /**
         * Sets the value of {@link OrganizationReference#getOrganizationId}
         * @param organizationId The Id of the Organization resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationId(java.lang.String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrganizationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrganizationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrganizationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationReference {
        private final java.lang.String organizationArn;
        private final java.lang.String organizationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.organizationArn = software.amazon.jsii.Kernel.get(this, "organizationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationId = software.amazon.jsii.Kernel.get(this, "organizationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.organizationArn = java.util.Objects.requireNonNull(builder.organizationArn, "organizationArn is required");
            this.organizationId = java.util.Objects.requireNonNull(builder.organizationId, "organizationId is required");
        }

        @Override
        public final java.lang.String getOrganizationArn() {
            return this.organizationArn;
        }

        @Override
        public final java.lang.String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("organizationArn", om.valueToTree(this.getOrganizationArn()));
            data.set("organizationId", om.valueToTree(this.getOrganizationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_organizations.OrganizationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrganizationReference.Jsii$Proxy that = (OrganizationReference.Jsii$Proxy) o;

            if (!organizationArn.equals(that.organizationArn)) return false;
            return this.organizationId.equals(that.organizationId);
        }

        @Override
        public final int hashCode() {
            int result = this.organizationArn.hashCode();
            result = 31 * result + (this.organizationId.hashCode());
            return result;
        }
    }
}
