package software.amazon.awscdk.interfaces.panorama;

/**
 * A reference to a PackageVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.panorama.*;
 * PackageVersionReference packageVersionReference = PackageVersionReference.builder()
 *         .packageId("packageId")
 *         .packageVersion("packageVersion")
 *         .patchVersion("patchVersion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.761Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_panorama.PackageVersionReference")
@software.amazon.jsii.Jsii.Proxy(PackageVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PackageVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The PackageId of the PackageVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackageId();

    /**
     * The PackageVersion of the PackageVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackageVersion();

    /**
     * The PatchVersion of the PackageVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPatchVersion();

    /**
     * @return a {@link Builder} of {@link PackageVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PackageVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PackageVersionReference> {
        java.lang.String packageId;
        java.lang.String packageVersion;
        java.lang.String patchVersion;

        /**
         * Sets the value of {@link PackageVersionReference#getPackageId}
         * @param packageId The PackageId of the PackageVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageId(java.lang.String packageId) {
            this.packageId = packageId;
            return this;
        }

        /**
         * Sets the value of {@link PackageVersionReference#getPackageVersion}
         * @param packageVersion The PackageVersion of the PackageVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageVersion(java.lang.String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        /**
         * Sets the value of {@link PackageVersionReference#getPatchVersion}
         * @param patchVersion The PatchVersion of the PackageVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder patchVersion(java.lang.String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PackageVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PackageVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PackageVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PackageVersionReference {
        private final java.lang.String packageId;
        private final java.lang.String packageVersion;
        private final java.lang.String patchVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.packageId = software.amazon.jsii.Kernel.get(this, "packageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packageVersion = software.amazon.jsii.Kernel.get(this, "packageVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.patchVersion = software.amazon.jsii.Kernel.get(this, "patchVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.packageId = java.util.Objects.requireNonNull(builder.packageId, "packageId is required");
            this.packageVersion = java.util.Objects.requireNonNull(builder.packageVersion, "packageVersion is required");
            this.patchVersion = java.util.Objects.requireNonNull(builder.patchVersion, "patchVersion is required");
        }

        @Override
        public final java.lang.String getPackageId() {
            return this.packageId;
        }

        @Override
        public final java.lang.String getPackageVersion() {
            return this.packageVersion;
        }

        @Override
        public final java.lang.String getPatchVersion() {
            return this.patchVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("packageId", om.valueToTree(this.getPackageId()));
            data.set("packageVersion", om.valueToTree(this.getPackageVersion()));
            data.set("patchVersion", om.valueToTree(this.getPatchVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_panorama.PackageVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PackageVersionReference.Jsii$Proxy that = (PackageVersionReference.Jsii$Proxy) o;

            if (!packageId.equals(that.packageId)) return false;
            if (!packageVersion.equals(that.packageVersion)) return false;
            return this.patchVersion.equals(that.patchVersion);
        }

        @Override
        public final int hashCode() {
            int result = this.packageId.hashCode();
            result = 31 * result + (this.packageVersion.hashCode());
            result = 31 * result + (this.patchVersion.hashCode());
            return result;
        }
    }
}
