package software.amazon.awscdk.interfaces.pinpoint;

/**
 * A reference to a APNSChannel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.pinpoint.*;
 * APNSChannelReference aPNSChannelReference = APNSChannelReference.builder()
 *         .apnsChannelId("apnsChannelId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.772Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_pinpoint.APNSChannelReference")
@software.amazon.jsii.Jsii.Proxy(APNSChannelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface APNSChannelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the APNSChannel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApnsChannelId();

    /**
     * @return a {@link Builder} of {@link APNSChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link APNSChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<APNSChannelReference> {
        java.lang.String apnsChannelId;

        /**
         * Sets the value of {@link APNSChannelReference#getApnsChannelId}
         * @param apnsChannelId The Id of the APNSChannel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apnsChannelId(java.lang.String apnsChannelId) {
            this.apnsChannelId = apnsChannelId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link APNSChannelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public APNSChannelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link APNSChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements APNSChannelReference {
        private final java.lang.String apnsChannelId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apnsChannelId = software.amazon.jsii.Kernel.get(this, "apnsChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apnsChannelId = java.util.Objects.requireNonNull(builder.apnsChannelId, "apnsChannelId is required");
        }

        @Override
        public final java.lang.String getApnsChannelId() {
            return this.apnsChannelId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apnsChannelId", om.valueToTree(this.getApnsChannelId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_pinpoint.APNSChannelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            APNSChannelReference.Jsii$Proxy that = (APNSChannelReference.Jsii$Proxy) o;

            return this.apnsChannelId.equals(that.apnsChannelId);
        }

        @Override
        public final int hashCode() {
            int result = this.apnsChannelId.hashCode();
            return result;
        }
    }
}
