package software.amazon.awscdk.interfaces.pinpoint;

/**
 * A reference to a APNSVoipChannel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.pinpoint.*;
 * APNSVoipChannelReference aPNSVoipChannelReference = APNSVoipChannelReference.builder()
 *         .apnsVoipChannelId("apnsVoipChannelId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.772Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_pinpoint.APNSVoipChannelReference")
@software.amazon.jsii.Jsii.Proxy(APNSVoipChannelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface APNSVoipChannelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the APNSVoipChannel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApnsVoipChannelId();

    /**
     * @return a {@link Builder} of {@link APNSVoipChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link APNSVoipChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<APNSVoipChannelReference> {
        java.lang.String apnsVoipChannelId;

        /**
         * Sets the value of {@link APNSVoipChannelReference#getApnsVoipChannelId}
         * @param apnsVoipChannelId The Id of the APNSVoipChannel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apnsVoipChannelId(java.lang.String apnsVoipChannelId) {
            this.apnsVoipChannelId = apnsVoipChannelId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link APNSVoipChannelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public APNSVoipChannelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link APNSVoipChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements APNSVoipChannelReference {
        private final java.lang.String apnsVoipChannelId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apnsVoipChannelId = software.amazon.jsii.Kernel.get(this, "apnsVoipChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apnsVoipChannelId = java.util.Objects.requireNonNull(builder.apnsVoipChannelId, "apnsVoipChannelId is required");
        }

        @Override
        public final java.lang.String getApnsVoipChannelId() {
            return this.apnsVoipChannelId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apnsVoipChannelId", om.valueToTree(this.getApnsVoipChannelId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_pinpoint.APNSVoipChannelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            APNSVoipChannelReference.Jsii$Proxy that = (APNSVoipChannelReference.Jsii$Proxy) o;

            return this.apnsVoipChannelId.equals(that.apnsVoipChannelId);
        }

        @Override
        public final int hashCode() {
            int result = this.apnsVoipChannelId.hashCode();
            return result;
        }
    }
}
