package software.amazon.awscdk.interfaces.proton;

/**
 * A reference to a EnvironmentTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.proton.*;
 * EnvironmentTemplateReference environmentTemplateReference = EnvironmentTemplateReference.builder()
 *         .environmentTemplateArn("environmentTemplateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.796Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_proton.EnvironmentTemplateReference")
@software.amazon.jsii.Jsii.Proxy(EnvironmentTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EnvironmentTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the EnvironmentTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentTemplateArn();

    /**
     * @return a {@link Builder} of {@link EnvironmentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EnvironmentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EnvironmentTemplateReference> {
        java.lang.String environmentTemplateArn;

        /**
         * Sets the value of {@link EnvironmentTemplateReference#getEnvironmentTemplateArn}
         * @param environmentTemplateArn The Arn of the EnvironmentTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentTemplateArn(java.lang.String environmentTemplateArn) {
            this.environmentTemplateArn = environmentTemplateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EnvironmentTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EnvironmentTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EnvironmentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentTemplateReference {
        private final java.lang.String environmentTemplateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.environmentTemplateArn = software.amazon.jsii.Kernel.get(this, "environmentTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.environmentTemplateArn = java.util.Objects.requireNonNull(builder.environmentTemplateArn, "environmentTemplateArn is required");
        }

        @Override
        public final java.lang.String getEnvironmentTemplateArn() {
            return this.environmentTemplateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("environmentTemplateArn", om.valueToTree(this.getEnvironmentTemplateArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_proton.EnvironmentTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EnvironmentTemplateReference.Jsii$Proxy that = (EnvironmentTemplateReference.Jsii$Proxy) o;

            return this.environmentTemplateArn.equals(that.environmentTemplateArn);
        }

        @Override
        public final int hashCode() {
            int result = this.environmentTemplateArn.hashCode();
            return result;
        }
    }
}
