package software.amazon.awscdk.interfaces.qbusiness;

/**
 * A reference to a WebExperience resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.qbusiness.*;
 * WebExperienceReference webExperienceReference = WebExperienceReference.builder()
 *         .applicationId("applicationId")
 *         .webExperienceArn("webExperienceArn")
 *         .webExperienceId("webExperienceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.802Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_qbusiness.WebExperienceReference")
@software.amazon.jsii.Jsii.Proxy(WebExperienceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebExperienceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationId of the WebExperience resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The ARN of the WebExperience resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebExperienceArn();

    /**
     * The WebExperienceId of the WebExperience resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebExperienceId();

    /**
     * @return a {@link Builder} of {@link WebExperienceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebExperienceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebExperienceReference> {
        java.lang.String applicationId;
        java.lang.String webExperienceArn;
        java.lang.String webExperienceId;

        /**
         * Sets the value of {@link WebExperienceReference#getApplicationId}
         * @param applicationId The ApplicationId of the WebExperience resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link WebExperienceReference#getWebExperienceArn}
         * @param webExperienceArn The ARN of the WebExperience resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webExperienceArn(java.lang.String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
            return this;
        }

        /**
         * Sets the value of {@link WebExperienceReference#getWebExperienceId}
         * @param webExperienceId The WebExperienceId of the WebExperience resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webExperienceId(java.lang.String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebExperienceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebExperienceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebExperienceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebExperienceReference {
        private final java.lang.String applicationId;
        private final java.lang.String webExperienceArn;
        private final java.lang.String webExperienceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webExperienceArn = software.amazon.jsii.Kernel.get(this, "webExperienceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webExperienceId = software.amazon.jsii.Kernel.get(this, "webExperienceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.webExperienceArn = java.util.Objects.requireNonNull(builder.webExperienceArn, "webExperienceArn is required");
            this.webExperienceId = java.util.Objects.requireNonNull(builder.webExperienceId, "webExperienceId is required");
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getWebExperienceArn() {
            return this.webExperienceArn;
        }

        @Override
        public final java.lang.String getWebExperienceId() {
            return this.webExperienceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("webExperienceArn", om.valueToTree(this.getWebExperienceArn()));
            data.set("webExperienceId", om.valueToTree(this.getWebExperienceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_qbusiness.WebExperienceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebExperienceReference.Jsii$Proxy that = (WebExperienceReference.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!webExperienceArn.equals(that.webExperienceArn)) return false;
            return this.webExperienceId.equals(that.webExperienceId);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.webExperienceArn.hashCode());
            result = 31 * result + (this.webExperienceId.hashCode());
            return result;
        }
    }
}
