package software.amazon.awscdk.interfaces.quicksight;

/**
 * A reference to a RefreshSchedule resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.quicksight.*;
 * RefreshScheduleReference refreshScheduleReference = RefreshScheduleReference.builder()
 *         .awsAccountId("awsAccountId")
 *         .dataSetId("dataSetId")
 *         .refreshScheduleArn("refreshScheduleArn")
 *         .scheduleId("scheduleId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.818Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_quicksight.RefreshScheduleReference")
@software.amazon.jsii.Jsii.Proxy(RefreshScheduleReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RefreshScheduleReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AwsAccountId of the RefreshSchedule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The DataSetId of the RefreshSchedule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataSetId();

    /**
     * The ARN of the RefreshSchedule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRefreshScheduleArn();

    /**
     * The Schedule/ScheduleId of the RefreshSchedule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduleId();

    /**
     * @return a {@link Builder} of {@link RefreshScheduleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RefreshScheduleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RefreshScheduleReference> {
        java.lang.String awsAccountId;
        java.lang.String dataSetId;
        java.lang.String refreshScheduleArn;
        java.lang.String scheduleId;

        /**
         * Sets the value of {@link RefreshScheduleReference#getAwsAccountId}
         * @param awsAccountId The AwsAccountId of the RefreshSchedule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link RefreshScheduleReference#getDataSetId}
         * @param dataSetId The DataSetId of the RefreshSchedule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetId(java.lang.String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        /**
         * Sets the value of {@link RefreshScheduleReference#getRefreshScheduleArn}
         * @param refreshScheduleArn The ARN of the RefreshSchedule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshScheduleArn(java.lang.String refreshScheduleArn) {
            this.refreshScheduleArn = refreshScheduleArn;
            return this;
        }

        /**
         * Sets the value of {@link RefreshScheduleReference#getScheduleId}
         * @param scheduleId The Schedule/ScheduleId of the RefreshSchedule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleId(java.lang.String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RefreshScheduleReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RefreshScheduleReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RefreshScheduleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshScheduleReference {
        private final java.lang.String awsAccountId;
        private final java.lang.String dataSetId;
        private final java.lang.String refreshScheduleArn;
        private final java.lang.String scheduleId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSetId = software.amazon.jsii.Kernel.get(this, "dataSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.refreshScheduleArn = software.amazon.jsii.Kernel.get(this, "refreshScheduleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleId = software.amazon.jsii.Kernel.get(this, "scheduleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.dataSetId = java.util.Objects.requireNonNull(builder.dataSetId, "dataSetId is required");
            this.refreshScheduleArn = java.util.Objects.requireNonNull(builder.refreshScheduleArn, "refreshScheduleArn is required");
            this.scheduleId = java.util.Objects.requireNonNull(builder.scheduleId, "scheduleId is required");
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final java.lang.String getRefreshScheduleArn() {
            return this.refreshScheduleArn;
        }

        @Override
        public final java.lang.String getScheduleId() {
            return this.scheduleId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("dataSetId", om.valueToTree(this.getDataSetId()));
            data.set("refreshScheduleArn", om.valueToTree(this.getRefreshScheduleArn()));
            data.set("scheduleId", om.valueToTree(this.getScheduleId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_quicksight.RefreshScheduleReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RefreshScheduleReference.Jsii$Proxy that = (RefreshScheduleReference.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!dataSetId.equals(that.dataSetId)) return false;
            if (!refreshScheduleArn.equals(that.refreshScheduleArn)) return false;
            return this.scheduleId.equals(that.scheduleId);
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.dataSetId.hashCode());
            result = 31 * result + (this.refreshScheduleArn.hashCode());
            result = 31 * result + (this.scheduleId.hashCode());
            return result;
        }
    }
}
