package software.amazon.awscdk.interfaces.quicksight;

/**
 * A reference to a Theme resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.quicksight.*;
 * ThemeReference themeReference = ThemeReference.builder()
 *         .awsAccountId("awsAccountId")
 *         .themeArn("themeArn")
 *         .themeId("themeId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.819Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_quicksight.ThemeReference")
@software.amazon.jsii.Jsii.Proxy(ThemeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThemeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AwsAccountId of the Theme resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The ARN of the Theme resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThemeArn();

    /**
     * The ThemeId of the Theme resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThemeId();

    /**
     * @return a {@link Builder} of {@link ThemeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThemeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThemeReference> {
        java.lang.String awsAccountId;
        java.lang.String themeArn;
        java.lang.String themeId;

        /**
         * Sets the value of {@link ThemeReference#getAwsAccountId}
         * @param awsAccountId The AwsAccountId of the Theme resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link ThemeReference#getThemeArn}
         * @param themeArn The ARN of the Theme resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeArn(java.lang.String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        /**
         * Sets the value of {@link ThemeReference#getThemeId}
         * @param themeId The ThemeId of the Theme resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeId(java.lang.String themeId) {
            this.themeId = themeId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThemeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThemeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThemeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThemeReference {
        private final java.lang.String awsAccountId;
        private final java.lang.String themeArn;
        private final java.lang.String themeId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.themeArn = software.amazon.jsii.Kernel.get(this, "themeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.themeId = software.amazon.jsii.Kernel.get(this, "themeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.themeArn = java.util.Objects.requireNonNull(builder.themeArn, "themeArn is required");
            this.themeId = java.util.Objects.requireNonNull(builder.themeId, "themeId is required");
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getThemeArn() {
            return this.themeArn;
        }

        @Override
        public final java.lang.String getThemeId() {
            return this.themeId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("themeArn", om.valueToTree(this.getThemeArn()));
            data.set("themeId", om.valueToTree(this.getThemeId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_quicksight.ThemeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThemeReference.Jsii$Proxy that = (ThemeReference.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!themeArn.equals(that.themeArn)) return false;
            return this.themeId.equals(that.themeId);
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.themeArn.hashCode());
            result = 31 * result + (this.themeId.hashCode());
            return result;
        }
    }
}
