package software.amazon.awscdk.interfaces.quicksight;

/**
 * A reference to a Topic resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.quicksight.*;
 * TopicReference topicReference = TopicReference.builder()
 *         .awsAccountId("awsAccountId")
 *         .topicArn("topicArn")
 *         .topicId("topicId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.819Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_quicksight.TopicReference")
@software.amazon.jsii.Jsii.Proxy(TopicReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TopicReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AwsAccountId of the Topic resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The ARN of the Topic resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

    /**
     * The TopicId of the Topic resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopicId();

    /**
     * @return a {@link Builder} of {@link TopicReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TopicReference> {
        java.lang.String awsAccountId;
        java.lang.String topicArn;
        java.lang.String topicId;

        /**
         * Sets the value of {@link TopicReference#getAwsAccountId}
         * @param awsAccountId The AwsAccountId of the Topic resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link TopicReference#getTopicArn}
         * @param topicArn The ARN of the Topic resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicArn(java.lang.String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        /**
         * Sets the value of {@link TopicReference#getTopicId}
         * @param topicId The TopicId of the Topic resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicId(java.lang.String topicId) {
            this.topicId = topicId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TopicReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TopicReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicReference {
        private final java.lang.String awsAccountId;
        private final java.lang.String topicArn;
        private final java.lang.String topicId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topicId = software.amazon.jsii.Kernel.get(this, "topicId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            this.topicId = java.util.Objects.requireNonNull(builder.topicId, "topicId is required");
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final java.lang.String getTopicId() {
            return this.topicId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("topicArn", om.valueToTree(this.getTopicArn()));
            data.set("topicId", om.valueToTree(this.getTopicId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_quicksight.TopicReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicReference.Jsii$Proxy that = (TopicReference.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!topicArn.equals(that.topicArn)) return false;
            return this.topicId.equals(that.topicId);
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.topicArn.hashCode());
            result = 31 * result + (this.topicId.hashCode());
            return result;
        }
    }
}
